/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.deobfus;

import com.nmmedit.apkprotect.deobfus.MappingProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class MappingReader {
    private final File mappingFile;
    private final InputStream mappingInput;

    public MappingReader(File mappingFile) {
        this.mappingFile = mappingFile;
        this.mappingInput = null;
    }

    public MappingReader(InputStream mappingInput) {
        this.mappingInput = mappingInput;
        this.mappingFile = null;
    }

    private Reader getMappingReader() throws IOException {
        if (this.mappingFile != null) {
            return new FileReader(this.mappingFile);
        }
        if (this.mappingInput != null) {
            return new InputStreamReader(this.mappingInput, StandardCharsets.UTF_8);
        }
        throw new IOException("No mapping");
    }

    public void parse(MappingProcessor processor) throws IOException {
        try (BufferedReader reader = new BufferedReader(this.getMappingReader());){
            String line;
            String className = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.endsWith(":")) {
                    className = this.processClassMapping(line, processor);
                    continue;
                }
                if (className == null) continue;
                this.processClassMemberMapping(className, line, processor);
            }
        }
    }

    private String processClassMapping(String line, MappingProcessor mappingProcessor) {
        int arrowIndex = line.indexOf("->");
        if (arrowIndex < 0) {
            return null;
        }
        int colonIndex = line.indexOf(58, arrowIndex + 2);
        if (colonIndex < 0) {
            return null;
        }
        String className = line.substring(0, arrowIndex).trim();
        String newClassName = line.substring(arrowIndex + 2, colonIndex).trim();
        mappingProcessor.processClassMapping(className, newClassName);
        return className;
    }

    private void processClassMemberMapping(String className, String line, MappingProcessor mappingProcessor) {
        int colonIndex4;
        int colonIndex1 = line.indexOf(58);
        int colonIndex2 = colonIndex1 < 0 ? -1 : line.indexOf(58, colonIndex1 + 1);
        int spaceIndex = line.indexOf(32, colonIndex2 + 2);
        int argumentIndex1 = line.indexOf(40, spaceIndex + 1);
        int argumentIndex2 = argumentIndex1 < 0 ? -1 : line.indexOf(41, argumentIndex1 + 1);
        int colonIndex3 = argumentIndex2 < 0 ? -1 : line.indexOf(58, argumentIndex2 + 1);
        int n11 = colonIndex4 = colonIndex3 < 0 ? -1 : line.indexOf(58, colonIndex3 + 1);
        int arrowIndex = line.indexOf("->", (colonIndex4 >= 0 ? colonIndex4 : (colonIndex3 >= 0 ? colonIndex3 : (argumentIndex2 >= 0 ? argumentIndex2 : spaceIndex))) + 1);
        if (spaceIndex < 0 || arrowIndex < 0) {
            return;
        }
        String type = line.substring(colonIndex2 + 1, spaceIndex).trim();
        String name = line.substring(spaceIndex + 1, argumentIndex1 >= 0 ? argumentIndex1 : arrowIndex).trim();
        String newName = line.substring(arrowIndex + 2).trim();
        String newClassName = className;
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex >= 0) {
            className = name.substring(0, dotIndex);
            name = name.substring(dotIndex + 1);
        }
        if (type.length() > 0 && name.length() > 0 && newName.length() > 0) {
            if (argumentIndex2 < 0) {
                mappingProcessor.processFieldMapping(className, type, name, newClassName, newName);
            } else {
                int firstLineNumber = 0;
                int lastLineNumber = 0;
                int newFirstLineNumber = 0;
                int newLastLineNumber = 0;
                if (colonIndex2 >= 0) {
                    firstLineNumber = newFirstLineNumber = Integer.parseInt(line.substring(0, colonIndex1).trim());
                    lastLineNumber = newLastLineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                }
                if (colonIndex3 >= 0) {
                    firstLineNumber = Integer.parseInt(line.substring(colonIndex3 + 1, colonIndex4 > 0 ? colonIndex4 : arrowIndex).trim());
                    lastLineNumber = colonIndex4 < 0 ? firstLineNumber : Integer.parseInt(line.substring(colonIndex4 + 1, arrowIndex).trim());
                }
                String arguments = line.substring(argumentIndex1 + 1, argumentIndex2).trim();
                mappingProcessor.processMethodMapping(className, firstLineNumber, lastLineNumber, type, name, arguments, newClassName, newFirstLineNumber, newLastLineNumber, newName);
            }
        }
    }
}

