/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.android.tools.smali.dexlib2.writer.io.FileDataStore;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import com.google.common.collect.HashMultimap;
import com.nmmedit.apkprotect.dex2c.DexConfig;
import com.nmmedit.apkprotect.dex2c.GlobalDexConfig;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.JniCodeGenerator;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.InstructionRewriter;
import com.nmmedit.apkprotect.dex2c.converter.structs.MethodConverter;
import com.nmmedit.apkprotect.dex2c.converter.structs.MyClassDef;
import com.nmmedit.apkprotect.dex2c.converter.structs.RegisterNativesCallerClassDef;
import com.nmmedit.apkprotect.dex2c.filters.ClassAndMethodFilter;
import com.nmmedit.apkprotect.util.Pair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class Dex2c {
    public static final String LANDROID_APP_APPLICATION = "Landroid/app/Application;";

    private Dex2c() {
    }

    public static GlobalDexConfig handleAllDex(@Nonnull List<File> dexFiles, @Nonnull ClassAndMethodFilter filter, @Nonnull InstructionRewriter instructionRewriter, @Nonnull ClassAnalyzer classAnalyzer, @Nonnull File outDir) throws IOException {
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        GlobalDexConfig globalConfig = new GlobalDexConfig(outDir);
        for (File file : dexFiles) {
            DexConfig config = Dex2c.handleDex(file, filter, classAnalyzer, instructionRewriter, outDir);
            config.setShellMethods(null);
            globalConfig.addDexConfig(config);
        }
        globalConfig.generateJniInitCode();
        return globalConfig;
    }

    public static DexConfig handleDex(@Nonnull File dexFile, @Nonnull ClassAndMethodFilter filter, @Nonnull ClassAnalyzer classAnalyzer, @Nonnull InstructionRewriter instructionRewriter, @Nonnull File outDir) throws IOException {
        return Dex2c.handleDex(new BufferedInputStream(new FileInputStream(dexFile)), dexFile.getName(), filter, classAnalyzer, instructionRewriter, outDir);
    }

    public static DexConfig handleModuleDex(@Nonnull File dexFile, @Nonnull ClassAndMethodFilter filter, @Nonnull ClassAnalyzer classAnalyzer, @Nonnull InstructionRewriter instructionRewriter, @Nonnull File outDir) throws IOException {
        GlobalDexConfig globalDexConfig = new GlobalDexConfig(outDir);
        DexConfig dexConfig = Dex2c.handleDex(dexFile, filter, classAnalyzer, instructionRewriter, outDir);
        globalDexConfig.addDexConfig(dexConfig);
        globalDexConfig.generateJniInitCode();
        return dexConfig;
    }

    public static DexConfig handleDex(@Nonnull InputStream dex, @Nonnull String dexFileName, @Nonnull ClassAndMethodFilter filter, @Nonnull ClassAnalyzer classAnalyzer, @Nonnull InstructionRewriter instructionRewriter, @Nonnull File outDir) throws IOException {
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        DexConfig config = Dex2c.splitDex(dex, dexFileName, filter, classAnalyzer, outDir);
        DexBackedDexFile nativeImplDexFile = DexBackedDexFile.fromInputStream(null, new BufferedInputStream(new FileInputStream(config.getImplDexFile())));
        try (FileWriter nativeCodeWriter = new FileWriter(config.getNativeFunctionsFile());
             FileWriter resolverWriter = new FileWriter(config.getResolverFile());){
            JniCodeGenerator codeGenerator = new JniCodeGenerator(nativeImplDexFile, classAnalyzer, instructionRewriter);
            codeGenerator.generate(config, resolverWriter, nativeCodeWriter);
            config.setResult(codeGenerator);
        }
        return config;
    }

    @Nonnull
    private static DexConfig splitDex(@Nonnull InputStream dex, @Nonnull String dexFileName, @Nonnull ClassAndMethodFilter filter, @Nonnull ClassAnalyzer classAnalyzer, @Nonnull File outDir) throws IOException {
        DexBackedDexFile originDexFile = DexBackedDexFile.fromInputStream(null, dex);
        DexPool shellDexPool = new DexPool(originDexFile.getOpcodes());
        DexPool nativeImplDexPool = new DexPool(originDexFile.getOpcodes());
        MethodConverter methodConverter = new MethodConverter(classAnalyzer);
        HashMultimap<String, List<? extends Method>> shellMethods = HashMultimap.create();
        for (ClassDef classDef : originDexFile.getClasses()) {
            if (filter.acceptClass(classDef)) {
                ArrayList<Method> shellDirectMethods = new ArrayList<Method>();
                ArrayList<Method> shellVirtualMethods = new ArrayList<Method>();
                ArrayList<Method> implDirectMethods = new ArrayList<Method>();
                ArrayList<Method> implVirtualMethods = new ArrayList<Method>();
                for (Method method : classDef.getMethods()) {
                    if (filter.acceptMethod(method)) {
                        Pair<List<? extends Method>, Method> pair = methodConverter.convert(method);
                        Dex2c.addMethods(shellDirectMethods, shellVirtualMethods, (List)pair.first);
                        shellMethods.put((Object)classDef.getType(), (Object)((List)pair.first));
                        Dex2c.addMethod(implDirectMethods, implVirtualMethods, (Method)pair.second);
                        continue;
                    }
                    Dex2c.addMethod(shellDirectMethods, shellVirtualMethods, method);
                }
                shellDexPool.internClass(new MyClassDef(classDef, shellDirectMethods, shellVirtualMethods));
                nativeImplDexPool.internClass(new MyClassDef(classDef, implDirectMethods, implVirtualMethods));
                continue;
            }
            shellDexPool.internClass(classDef);
        }
        DexConfig config = new DexConfig(outDir, dexFileName);
        config.setShellMethods(shellMethods);
        shellDexPool.writeTo(new FileDataStore(config.getShellDexFile()));
        nativeImplDexPool.writeTo(new FileDataStore(config.getImplDexFile()));
        return config;
    }

    private static void addMethods(List<Method> directMethods, List<Method> virtualMethods, List<? extends Method> methods) {
        for (Method method : methods) {
            Dex2c.addMethod(directMethods, virtualMethods, method);
        }
    }

    private static void addMethod(List<Method> directMethods, List<Method> virtualMethods, Method method) {
        if (MethodUtil.isDirect(method)) {
            directMethods.add(method);
        } else {
            virtualMethods.add(method);
        }
    }

    public static List<DexPool> injectCallRegisterNativeInsns(DexConfig config, DexPool lastDexPool, Set<String> mainClassSet, int maxPoolSize) throws IOException {
        DexBackedDexFile dexNativeFile = DexBackedDexFile.fromInputStream(null, new BufferedInputStream(new FileInputStream(config.getShellDexFile())));
        ArrayList<DexPool> dexPools = new ArrayList<DexPool>();
        dexPools.add(lastDexPool);
        for (ClassDef classDef : dexNativeFile.getClasses()) {
            if (mainClassSet.contains(classDef.getType())) continue;
            Dex2c.internClass(config, lastDexPool, classDef);
            if (!lastDexPool.hasOverflowed(maxPoolSize)) continue;
            lastDexPool = new DexPool(dexNativeFile.getOpcodes());
            dexPools.add(lastDexPool);
        }
        return dexPools;
    }

    private static void internClass(DexConfig config, DexPool dexPool, ClassDef classDef) {
        String type;
        String className;
        Set<String> classes = config.getHandledNativeClasses();
        if (classes.contains(className = (type = classDef.getType()).substring(1, type.length() - 1))) {
            RegisterNativesCallerClassDef nativeClassDef = new RegisterNativesCallerClassDef(classDef, config.getOffsetFromClassName(className), "L" + config.getRegisterNativesClassName() + ";", config.getRegisterNativesMethodName());
            dexPool.internClass(nativeClassDef);
        } else {
            dexPool.internClass(classDef);
        }
    }
}

