/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c;

import com.android.tools.smali.dexlib2.iface.Method;
import com.google.common.collect.HashMultimap;
import com.nmmedit.apkprotect.dex2c.converter.JniCodeGenerator;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class DexConfig {
    private final File outputDir;
    private final String dexName;
    private HashMultimap<String, List<? extends Method>> shellMethods;
    private Set<String> handledNativeClasses;
    private Map<String, Integer> nativeMethodOffsets;

    public DexConfig(File outputDir, String dexFileName) {
        this.outputDir = outputDir;
        int i11 = dexFileName.lastIndexOf(46);
        this.dexName = i11 != -1 ? dexFileName.substring(0, i11) : dexFileName;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public String getDexName() {
        return this.dexName;
    }

    public String getRegisterNativesClassName() {
        return "com/nmmedit/protect/NativeUtil";
    }

    public String getRegisterNativesMethodName() {
        return this.getDexName() + "Init0";
    }

    @Nonnull
    public Set<String> getHandledNativeClasses() {
        return this.handledNativeClasses;
    }

    public int getOffsetFromClassName(String className) {
        return this.nativeMethodOffsets.get(className);
    }

    public void setResult(JniCodeGenerator codeGenerator) {
        this.handledNativeClasses = codeGenerator.getHandledNativeClasses();
        this.nativeMethodOffsets = codeGenerator.getNativeMethodOffsets();
    }

    public void setShellMethods(HashMultimap<String, List<? extends Method>> shellMethods) {
        this.shellMethods = shellMethods;
    }

    public HashMultimap<String, List<? extends Method>> getShellMethods() {
        return this.shellMethods;
    }

    public File getShellDexFile() {
        return new File(this.outputDir, this.dexName + "_shell.dex");
    }

    public File getImplDexFile() {
        return new File(this.outputDir, this.dexName + "_impl.dex");
    }

    public File getNativeFunctionsFile() {
        return new File(this.outputDir, this.dexName + "_native_functions.c");
    }

    public HeaderFileAndSetupFuncName getHeaderFileAndSetupFunc() {
        return new HeaderFileAndSetupFuncName(new File(this.outputDir, this.dexName + "_native_functions.h"), this.dexName + "_setup");
    }

    public File getResolverFile() {
        return new File(this.outputDir, this.dexName + "_resolver.c");
    }

    public static class HeaderFileAndSetupFuncName {
        public final File headerFile;
        public final String setupFunctionName;

        private HeaderFileAndSetupFuncName(File headerFile, String setupFunctionName) {
            this.headerFile = headerFile;
            this.setupFunctionName = setupFunctionName;
        }
    }
}

