/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c;

import com.nmmedit.apkprotect.dex2c.DexConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class GlobalDexConfig {
    private final ArrayList<DexConfig> configs = new ArrayList();
    private final File outputDir;

    public GlobalDexConfig(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getInitCodeFile() {
        return new File(this.outputDir, "jni_init.c");
    }

    public void addDexConfig(DexConfig config) {
        this.configs.add(config);
    }

    public List<DexConfig> getConfigs() {
        return this.configs;
    }

    public void generateJniInitCode() throws IOException {
        try (FileWriter writer = new FileWriter(this.getInitCodeFile());){
            this.generateJniInitCode(writer);
        }
    }

    private void generateJniInitCode(Writer writer) throws IOException {
        StringBuilder includeStaOrExternFunc = new StringBuilder();
        StringBuilder initCallSta = new StringBuilder();
        for (DexConfig config : this.configs) {
            DexConfig.HeaderFileAndSetupFuncName setupFunc = config.getHeaderFileAndSetupFunc();
            includeStaOrExternFunc.append(String.format("extern void %s(JNIEnv *env);\n", setupFunc.setupFunctionName));
            initCallSta.append(String.format("    %s(env);\n", setupFunc.setupFunctionName));
        }
        writer.write(String.format("#include <jni.h>\n#include \"GlobalCache.h\"\n\n//auto generated\n%s\n\nJNIEXPORT jint JNI_OnLoad(JavaVM *vm, void *reserved) {\n    JNIEnv *env;\n    if ((*vm)->GetEnv(vm, (void **) &env, JNI_VERSION_1_6) != JNI_OK) {\n        return -1;\n    }\n    cacheInitial(env);\n\n\n    //auto generated setup function\n%s\n\n    return JNI_VERSION_1_6;\n}\n\n\n", includeStaOrExternFunc.toString(), initCallSta.toString()));
    }
}

