/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableFieldReference;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassAnalyzer {
    private final Map<String, ClassDef> allClasses = Maps.newHashMap();
    private boolean hasJna;
    private int minSdk = 21;

    public void setMinSdk(int minSdk) {
        this.minSdk = minSdk;
    }

    public void loadDexFile(@Nonnull File dexFile) throws IOException {
        this.loadDexFile(DexBackedDexFile.fromInputStream(null, new BufferedInputStream(new FileInputStream(dexFile))));
    }

    public void loadDexFile(@Nonnull DexBackedDexFile dexFile) {
        for (DexBackedClassDef dexBackedClassDef : dexFile.getClasses()) {
            this.allClasses.put(dexBackedClassDef.getType(), dexBackedClassDef);
        }
        if (!this.hasJna) {
            this.hasJna = this.allClasses.containsKey("Lcom/sun/jna/Native;");
        }
    }

    public boolean hasJnaLib() {
        return this.hasJna;
    }

    public boolean hasCallJnaMethod(@Nonnull Method method) {
        if (!this.hasJnaLib()) {
            return false;
        }
        MethodImplementation implementation = method.getImplementation();
        if (implementation == null) {
            return false;
        }
        for (Instruction instruction : implementation.getInstructions()) {
            switch (instruction.getOpcode()) {
                case INVOKE_INTERFACE: 
                case INVOKE_INTERFACE_RANGE: {
                    MethodReference methodReference = (MethodReference)((ReferenceInstruction)instruction).getReference();
                    if (!this.matchInterface(this.allClasses.get(methodReference.getDefiningClass()), "Lcom/sun/jna/Library;")) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchInterface(ClassDef classDef, String interfaceType) {
        if (classDef == null) {
            return false;
        }
        Iterator<String> iterator = classDef.getInterfaces().iterator();
        if (iterator.hasNext()) {
            String defInterface = iterator.next();
            if (defInterface.equals(interfaceType)) {
                return true;
            }
            ClassDef ifClass = this.allClasses.get(defInterface);
            return this.matchInterface(ifClass, interfaceType);
        }
        return false;
    }

    public FieldReference getDirectFieldRef(FieldReference reference) {
        String fieldType;
        ClassDef classDef = this.allClasses.get(reference.getDefiningClass());
        if (classDef == null) {
            return null;
        }
        String fieldName = reference.getName();
        ClassDef newClassDef = this.findFieldDefiningClass(classDef, fieldName, fieldType = reference.getType());
        if (newClassDef != null) {
            return new ImmutableFieldReference(newClassDef.getType(), fieldName, fieldType);
        }
        return null;
    }

    private ClassDef findFieldDefiningClass(ClassDef classDef, String fieldName, String fieldType) {
        if (classDef == null) {
            return null;
        }
        for (Field field : classDef.getStaticFields()) {
            if (!field.getName().equals(fieldName) || !field.getType().equals(fieldType)) continue;
            return classDef;
        }
        for (String string : classDef.getInterfaces()) {
            ClassDef definingClass = this.findFieldDefiningClass(this.allClasses.get(string), fieldName, fieldType);
            if (definingClass == null) continue;
            return definingClass;
        }
        return null;
    }

    @Nullable
    public MethodReference findDirectMethod(@Nonnull MethodReference method) {
        if (this.minSdk < 23) {
            ClassDef classDef = this.allClasses.get(method.getDefiningClass());
            if (classDef == null) {
                return null;
            }
            ClassDef superClass = this.allClasses.get(classDef.getSuperclass());
            return this.findDirectMethod(superClass, method.getName(), method.getParameterTypes(), method.getReturnType());
        }
        return null;
    }

    @Nullable
    public ClassDef getClassDef(@Nonnull String className) {
        return this.allClasses.get(className);
    }

    @Nullable
    private MethodReference findDirectMethod(@Nonnull ClassDef thisClass, @Nonnull String name, @Nonnull List<? extends CharSequence> parameterTypes, @Nonnull String returnType) {
        ClassDef classDef = thisClass;
        while (classDef != null) {
            for (Method method : classDef.getDirectMethods()) {
                if (!method.getName().equals(name) || !method.getParameterTypes().equals(parameterTypes) || !method.getReturnType().equals(returnType)) continue;
                return method;
            }
            classDef = this.allClasses.get(classDef.getSuperclass());
        }
        return null;
    }

    @Nullable
    public MethodReference findMethod(@Nonnull ClassDef thisClass, @Nonnull String name, @Nonnull List<? extends CharSequence> parameterTypes, @Nonnull String returnType) {
        ClassDef classDef = thisClass;
        while (classDef != null) {
            for (Method method : classDef.getMethods()) {
                if (!method.getName().equals(name) || !method.getParameterTypes().equals(parameterTypes) || !method.getReturnType().equals(returnType)) continue;
                return method;
            }
            classDef = this.allClasses.get(classDef.getSuperclass());
        }
        return null;
    }
}

