/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.google.common.collect.HashMultimap;
import com.nmmedit.apkprotect.dex2c.DexConfig;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.MyMethodUtil;
import com.nmmedit.apkprotect.dex2c.converter.References;
import com.nmmedit.apkprotect.dex2c.converter.ResolverCodeGenerator;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.InstructionRewriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class JniCodeGenerator {
    private final boolean isRegisterNative = true;
    private final HashMultimap<String, MyMethod> handledNativeMethods = HashMultimap.create();
    private final Map<String, Integer> nativeMethodOffsets = new HashMap<String, Integer>();
    private final ResolverCodeGenerator resolverCodeGenerator;
    private final InstructionRewriter instructionRewriter;
    private final DexBackedDexFile dexFile;

    public JniCodeGenerator(@Nonnull DexBackedDexFile dexFile, @Nonnull ClassAnalyzer analyzer, @Nonnull InstructionRewriter instructionRewriter) {
        this.dexFile = dexFile;
        this.resolverCodeGenerator = new ResolverCodeGenerator(dexFile, analyzer);
        this.instructionRewriter = instructionRewriter;
        instructionRewriter.loadReferences(this.resolverCodeGenerator.getReferences(), analyzer);
    }

    public void addMethod(Method method, Writer writer) throws IOException {
        boolean hasReturnValue;
        StringBuilder regFlagsAssign;
        StringBuilder regsAssign;
        boolean useStack;
        MethodImplementation implementation = method.getImplementation();
        if (implementation == null) {
            return;
        }
        boolean isStatic = AccessFlags.STATIC.isSet(method.getAccessFlags());
        String classType = method.getDefiningClass();
        String methodName = method.getName();
        int registerCount = implementation.getRegisterCount();
        List<? extends CharSequence> parameterTypes = method.getParameterTypes();
        int parameterRegisterCount = MethodUtil.getParameterRegisterCount(parameterTypes, isStatic);
        String returnType = method.getReturnType();
        String clazzName = classType.substring(1, classType.length() - 1);
        this.handledNativeMethods.put((Object)clazzName, (Object)new MyMethod(clazzName, methodName, parameterTypes, returnType));
        writer.write(String.format("%s %s %s(JNIEnv *env, %s ", "static", JniCodeGenerator.getJNIType(returnType), MyMethodUtil.getJniFunctionName(clazzName, methodName, parameterTypes, returnType), isStatic ? "jclass jcls" : "jobject thiz"));
        boolean bl2 = useStack = registerCount <= 8;
        if (useStack) {
            int i11;
            regsAssign = new StringBuilder(String.format("    regptr_t regs[%d];\n", registerCount));
            for (i11 = 0; i11 < registerCount; ++i11) {
                regsAssign.append(String.format("    regs[%d] = 0;\n", i11));
            }
            regFlagsAssign = new StringBuilder(String.format("    u1 reg_flags[%d];\n", registerCount));
            for (i11 = 0; i11 < registerCount; ++i11) {
                regFlagsAssign.append(String.format("    reg_flags[%d] = 0;\n", i11));
            }
        } else {
            regsAssign = new StringBuilder(String.format("    regptr_t *regs = (regptr_t *) calloc(%d, sizeof(regptr_t) + sizeof(u1));\n", registerCount));
            regFlagsAssign = new StringBuilder(String.format("    u1 *reg_flags = ((u1 *) regs) + (%d * sizeof(regptr_t));\n", registerCount));
        }
        int paramRegStart = registerCount - parameterRegisterCount;
        if (!isStatic) {
            regsAssign.append(String.format("    regs[%d] = (regptr_t) thiz;\n", paramRegStart));
            regFlagsAssign.append(String.format("    reg_flags[%d] = 1;\n", paramRegStart));
            ++paramRegStart;
        }
        StringBuilder params = new StringBuilder();
        int size = parameterTypes.size();
        for (int i12 = 0; i12 < size; ++i12) {
            String type = parameterTypes.get(i12).toString();
            String jniType = JniCodeGenerator.getJNIType(type);
            int argNum = isStatic ? i12 : i12 + 1;
            params.append(jniType).append(" p").append(argNum);
            if (type.startsWith("[") || type.startsWith("L")) {
                regsAssign.append(String.format("    regs[%d] = (regptr_t) p%d;\n", paramRegStart, argNum));
                regFlagsAssign.append(String.format("    reg_flags[%d] = 1;\n", paramRegStart));
                ++paramRegStart;
            } else if (type.equals("F")) {
                regsAssign.append(String.format("    SET_REGISTER_FLOAT(%d, p%d);\n", paramRegStart++, argNum));
            } else if (type.equals("D")) {
                regsAssign.append(String.format("    SET_REGISTER_DOUBLE(%d, p%d);\n", paramRegStart++, argNum));
                ++paramRegStart;
            } else if (type.equals("J")) {
                regsAssign.append(String.format("    SET_REGISTER_WIDE(%d, p%d);\n", paramRegStart++, argNum));
                ++paramRegStart;
            } else {
                regsAssign.append(String.format("    regs[%d] = p%d;\n", paramRegStart++, argNum));
            }
            if (i12 >= size - 1) continue;
            params.append(", ");
        }
        if (params.length() > 0) {
            writer.append(", ").append(params.toString());
        }
        writer.append(") {\n");
        writer.append(regsAssign);
        writer.append("\n");
        writer.append(regFlagsAssign);
        writer.append("\n");
        writer.append("    static const u2 insns[] = {");
        byte[] instructionData = this.instructionRewriter.rewriteInstructions(implementation);
        int dataLength = instructionData.length;
        DexBuffer instructionBuf = new DexBuffer(instructionData);
        for (int offset = 0; offset < dataLength; offset += 2) {
            if (offset % 20 == 0) {
                writer.append("\n");
            }
            writer.append(String.format("0x%04x, ", instructionBuf.readUshort(offset)));
        }
        writer.append("\n    };\n");
        byte[] tries = this.instructionRewriter.handleTries(implementation);
        StringBuilder triesBuilder = new StringBuilder();
        if (tries.length == 0) {
            triesBuilder.append("    const u1 *tries = NULL;\n");
        } else {
            triesBuilder.append("    static const u1 tries[] = {");
            for (int i13 = 0; i13 < tries.length; ++i13) {
                if (i13 % 10 == 0) {
                    triesBuilder.append("\n");
                }
                triesBuilder.append(String.format("0x%02x, ", tries[i13] & 0xFF));
            }
            triesBuilder.append("\n    };\n");
        }
        writer.write(triesBuilder.toString());
        writer.write(String.format("\n    const vmCode code = {\n            .insns=insns,\n            .insnsSize=%d,\n            .regs=regs,\n            .reg_flags=reg_flags,\n            .triesHandlers=tries\n    };\n\n", dataLength / 2));
        boolean bl3 = hasReturnValue = !returnType.equals("V");
        if (hasReturnValue) {
            writer.write("\n    volatile jvalue value = vmInterpret(env,\n                                &code,\n                                &dvmResolver);\n");
        } else {
            writer.write("\n    vmInterpret(env,\n              &code,\n              &dvmResolver);\n");
        }
        if (!useStack) {
            writer.write("    free(regs);\n");
        }
        if (hasReturnValue) {
            char typeCh = returnType.charAt(0);
            writer.append(String.format("    return value.%s;\n", Character.valueOf(Character.toLowerCase(typeCh == '[' ? (char)'L' : (char)typeCh))));
        }
        writer.append("}\n\n");
    }

    public Set<String> getHandledNativeClasses() {
        return this.handledNativeMethods.keySet();
    }

    public Map<String, Integer> getNativeMethodOffsets() {
        return this.nativeMethodOffsets;
    }

    public void generate(DexConfig config, Writer resolverWriter, Writer codeWriter) throws IOException {
        this.resolverCodeGenerator.generate(resolverWriter);
        codeWriter.write(String.format("\n#include <stdio.h>\n#include <string.h>\n#include <malloc.h>\n#include <jni.h>\n#include \"vm.h\"\n#include \"%s\"\n\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n\n#define SET_REGISTER_FLOAT(_idx, _val)      (*((float*) &regs[(_idx)]) = (_val))\n\n\n#define SET_REGISTER_WIDE(_idx, _val)       (regs[(_idx)] =(s8) (_val));\n\n#define SET_REGISTER_DOUBLE(_idx, _val)     (*((double*) &regs[(_idx)]) = (_val));\n\n\n", config.getResolverFile().getName()));
        for (DexBackedClassDef dexBackedClassDef : this.dexFile.getClasses()) {
            for (DexBackedMethod dexBackedMethod : dexBackedClassDef.getMethods()) {
                this.addMethod(dexBackedMethod, codeWriter);
            }
        }
        this.generateNativeMethodCode(config, codeWriter);
        codeWriter.write(String.format("void %s(JNIEnv *env) {\n", config.getHeaderFileAndSetupFunc().setupFunctionName));
        codeWriter.write("\n    //\u7b26\u53f7\u89e3\u6790\u5668\u521d\u59cb\u5316\n");
        codeWriter.write("    resolver_init(env);\n\n");
        codeWriter.write("    //\u6ce8\u518c\n");
        String funName = MyMethodUtil.getJniFunctionName(config.getRegisterNativesClassName(), config.getRegisterNativesMethodName(), Collections.singletonList("I"), "V");
        codeWriter.write(String.format("    jclass clazz = (*env)->FindClass(env, \"%s\");\n    static const JNINativeMethod nativeMethod = {\n        .name=\"%s\",\n        .signature=\"(I)V\",\n        .fnPtr=%s\n    };\n   (*env)->RegisterNatives(env, clazz, &nativeMethod, 1);\n\n   (*env)->DeleteLocalRef(env, clazz);\n\n", config.getRegisterNativesClassName(), config.getRegisterNativesMethodName(), funName));
        codeWriter.write("}\n");
        codeWriter.write("\n\n#ifdef __cplusplus\n}\n#endif\n\n");
    }

    private void generateNativeMethodCode(DexConfig config, Writer writer) throws IOException {
        HashMap<Object, Ranger> methodRanger = new HashMap<Object, Ranger>();
        writer.write("\ntypedef struct{\n    u4 nameIdx;\n    u4 sigIdx;\n    void *fnPtr;\n} MyNativeMethod;\n");
        int methodIdx = 0;
        writer.write("static const MyNativeMethod gNativeMethods[] = {\n");
        References references = this.resolverCodeGenerator.getReferences();
        for (Object clazz : this.handledNativeMethods.keySet()) {
            int n11 = methodIdx;
            Set methods = this.handledNativeMethods.get(clazz);
            for (MyMethod method : methods) {
                int nameIdx = references.getStringItemIndex(method.name);
                int sigIdx = references.getStringItemIndex(MyMethodUtil.getMethodSignature(method.parameterTypes, method.returnType));
                writer.write(String.format("    {%d, %d, (void *) %s},\n", nameIdx, sigIdx, MyMethodUtil.getJniFunctionName(method.className, method.name, method.parameterTypes, method.returnType)));
                ++methodIdx;
            }
            methodRanger.put(clazz, new Ranger(n11, methodIdx - n11));
        }
        writer.write("};\n");
        writer.write("//ends native method\n");
        writer.write("\ntypedef struct {\n    u4 classIdx;\n    u4 offset;\n    u4 count;\n} NativeMethodData;\n");
        writer.write("static const NativeMethodData gNativeRegisterData[] = {\n");
        int dataOff = 0;
        for (Map.Entry entry : methodRanger.entrySet()) {
            Ranger ranger = (Ranger)entry.getValue();
            String className = (String)entry.getKey();
            int classIdx = references.getClassNameItemIndex(className);
            writer.write(String.format("    {.classIdx = %d, .offset = %d, .count = %d},\n", classIdx, ranger.start, ranger.count));
            this.nativeMethodOffsets.put(className, dataOff++);
        }
        writer.write("};\n\n");
        String funName = MyMethodUtil.getJniFunctionName(config.getRegisterNativesClassName(), config.getRegisterNativesMethodName(), Collections.singletonList("I"), "V");
        writer.write(String.format("static void %s(JNIEnv *env, jclass jcls, jint dataIdx){\n#define MAX_METHOD 8\n    JNINativeMethod methodBuf[MAX_METHOD];\n\n    JNINativeMethod *methods;\n    const NativeMethodData data = gNativeRegisterData[(u4) dataIdx];\n    if (data.count > MAX_METHOD) {\n        methods = (JNINativeMethod *) malloc(sizeof(JNINativeMethod) * data.count);\n    } else {\n        //\u65b9\u6cd5\u6570\u6bd4\u8f83\u5c0f\u76f4\u63a5\u4f7f\u7528\u6808\u5185\u5b58,\u51cf\u5c11\u5185\u5b58\u5206\u914d\u548c\u91ca\u653e\n        methods = methodBuf;\n    }\n\n    jclass clazz = (*env)->FindClass(env, STRING_BY_CLASS_ID(data.classIdx));\n    if (clazz == NULL) {\n        return;\n    }\n    for (int midx = 0; midx < data.count; ++midx) {\n        MyNativeMethod myNativeMethod = gNativeMethods[data.offset + midx];\n\n        JNINativeMethod *method = methods + midx;\n        method->name = STRING_BY_ID(myNativeMethod.nameIdx);\n        method->signature = STRING_BY_ID(myNativeMethod.sigIdx);\n        method->fnPtr = myNativeMethod.fnPtr;\n    }\n\n    (*env)->RegisterNatives(env, clazz, methods, data.count);\n\n    (*env)->DeleteLocalRef(env, clazz);\n\n    //\u4e0d\u76f8\u7b49\u8868\u793a\u4f7f\u7528malloc\u7533\u8bf7\u7684\u5185\u5b58\u9700\u8981\u91ca\u653e\n    if (methods != methodBuf)free(methods);\n}\n\n", funName));
    }

    public static String getJNIType(String type) {
        switch (type) {
            case "Z": {
                return "jboolean";
            }
            case "B": {
                return "jbyte";
            }
            case "S": {
                return "jshort";
            }
            case "C": {
                return "jchar";
            }
            case "I": {
                return "jint";
            }
            case "F": {
                return "jfloat";
            }
            case "J": {
                return "jlong";
            }
            case "D": {
                return "jdouble";
            }
            case "V": {
                return "void";
            }
        }
        return "jobject";
    }

    private static class Ranger {
        final int start;
        final int count;

        Ranger(int start, int count) {
            this.start = start;
            this.count = count;
        }

        public boolean equals(Object o11) {
            if (this == o11) {
                return true;
            }
            if (o11 == null || this.getClass() != o11.getClass()) {
                return false;
            }
            Ranger ranger = (Ranger)o11;
            if (this.start != ranger.start) {
                return false;
            }
            return this.count == ranger.count;
        }

        public int hashCode() {
            int result = this.start;
            result = 31 * result + this.count;
            return result;
        }
    }

    private static class MyMethod {
        final String className;
        final String name;
        final List<? extends CharSequence> parameterTypes;
        final String returnType;

        MyMethod(String className, String name, List<? extends CharSequence> parameterTypes, String returnType) {
            this.className = className;
            this.name = name;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        public boolean equals(Object o11) {
            if (this == o11) {
                return true;
            }
            if (o11 == null || this.getClass() != o11.getClass()) {
                return false;
            }
            MyMethod myMethod = (MyMethod)o11;
            if (!this.className.equals(myMethod.className)) {
                return false;
            }
            if (!this.name.equals(myMethod.name)) {
                return false;
            }
            if (!this.parameterTypes.equals(myMethod.parameterTypes)) {
                return false;
            }
            return this.returnType.equals(myMethod.returnType);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            result = 31 * result + this.returnType.hashCode();
            return result;
        }
    }
}

