/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.util.Hex;
import java.util.List;
import javax.annotation.Nonnull;

public class MyMethodUtil {
    public static boolean isConstructorOrAbstract(Method method) {
        String name = method.getName();
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return true;
        }
        int accessFlags = method.getAccessFlags();
        return AccessFlags.NATIVE.isSet(accessFlags) || AccessFlags.ABSTRACT.isSet(accessFlags);
    }

    public static boolean isBridgeOrSynthetic(Method method) {
        int flags = method.getAccessFlags();
        return AccessFlags.BRIDGE.isSet(flags) || AccessFlags.SYNTHETIC.isSet(flags);
    }

    @Nonnull
    public static String getMethodSignature(List<? extends CharSequence> parameterTypes, String returnType) {
        StringBuilder sig = new StringBuilder();
        sig.append("(");
        for (CharSequence charSequence : parameterTypes) {
            sig.append(charSequence);
        }
        sig.append(")");
        sig.append(returnType);
        return sig.toString();
    }

    @Nonnull
    public static String getJniFunctionName(String className, String methodName, List<? extends CharSequence> parameterTypes, String returnType) {
        StringBuilder funcName = new StringBuilder("Java_");
        funcName.append(MyMethodUtil.nameReplace(className).replace('/', '_'));
        funcName.append('_');
        funcName.append(MyMethodUtil.nameReplace(methodName));
        if (!parameterTypes.isEmpty()) {
            funcName.append("__");
            for (CharSequence charSequence : parameterTypes) {
                funcName.append(MyMethodUtil.nameReplace(charSequence.toString()).replace('/', '_'));
            }
        }
        if (returnType != null) {
            funcName.append('_').append(MyMethodUtil.nameReplace(returnType).replace('/', '_'));
        }
        return funcName.toString();
    }

    private static String nameReplace(String s11) {
        int length = s11.length();
        StringBuilder sb2 = new StringBuilder(length * 6);
        block6: for (int i11 = 0; i11 < length; ++i11) {
            char c11 = s11.charAt(i11);
            switch (c11) {
                case '_': {
                    sb2.append("_1");
                    continue block6;
                }
                case ';': {
                    sb2.append("_2");
                    continue block6;
                }
                case '[': {
                    sb2.append("_3");
                    continue block6;
                }
                case '$': 
                case '+': 
                case '-': {
                    sb2.append("_0");
                    sb2.append(Hex.u2(c11));
                    continue block6;
                }
                default: {
                    if ((c11 & 0xFFFF) > 127) {
                        sb2.append("_0");
                        sb2.append(Hex.u2(c11));
                        continue block6;
                    }
                    sb2.append(c11);
                }
            }
        }
        return sb2.toString();
    }
}

