/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.ExceptionHandler;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.TryBlock;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.StringReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.google.common.collect.Sets;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.util.ModifiedUtf8;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

public class References {
    private final ClassAnalyzer analyzer;
    int maxTypeLen = 0;
    private final HashSet<String> stringRefs = Sets.newHashSet();
    private final HashSet<String> typeRefs = Sets.newHashSet();
    private final HashSet<MyFieldRef> fieldRefs = Sets.newHashSet();
    private final HashSet<MyMethodRef> methodRefs = Sets.newHashSet();
    private final HashSet<String> signatureRefs = Sets.newHashSet();
    private final HashSet<String> constantStrings = Sets.newHashSet();
    private final HashSet<String> extStringRefs = Sets.newHashSet();
    final ArrayList<String> stringPool = new ArrayList();
    private final HashMap<String, Integer> stringPoolIndexMap = new HashMap();
    final ArrayList<String> constStringPool = new ArrayList();
    private final HashMap<String, Integer> constStringPoolIndexMap = new HashMap();
    private final ArrayList<String> typePool = new ArrayList();
    private final HashMap<String, Integer> typePoolIndexMap = new HashMap();
    private final ArrayList<String> classNamePool = new ArrayList();
    private final HashMap<String, Integer> classNamePoolIndexMap = new HashMap();
    private final ArrayList<String> signaturePool = new ArrayList();
    private final HashMap<String, Integer> signaturePoolIndexMap = new HashMap();
    private final ArrayList<FieldReference> fieldPool = new ArrayList();
    private final HashMap<FieldReference, Integer> fieldPoolIndexMap = new HashMap();
    private final ArrayList<MethodReference> methodPool = new ArrayList();
    private final HashMap<MethodReference, Integer> methodPoolIndexMap = new HashMap();

    References(@Nonnull DexBackedDexFile dexFile, @Nonnull ClassAnalyzer analyzer) {
        this.analyzer = analyzer;
        this.parseReferences(dexFile);
    }

    private void addStringRef(String type) {
        this.stringRefs.add(type);
    }

    private void addTypeRef(String type) {
        if (type == null) {
            return;
        }
        this.stringRefs.add(type);
        this.extStringRefs.add(References.typeToClassName(type));
        this.typeRefs.add(type);
    }

    private void addConstStringRef(String type) {
        this.stringRefs.add(type);
        this.constantStrings.add(type);
    }

    private void addSignatureRef(String type) {
        this.extStringRefs.add(type);
        this.signatureRefs.add(type);
    }

    private void addExtStringRef(String type) {
        this.stringRefs.add(type);
    }

    @Nonnull
    private static String typeToClassName(@Nonnull String type) {
        if (type.charAt(0) == 'L') {
            return type.substring(1, type.length() - 1);
        }
        return type;
    }

    private void addMethodSignature(MethodReference reference) {
        List<? extends CharSequence> parameterTypes = reference.getParameterTypes();
        StringBuilder sig = new StringBuilder();
        sig.append("(");
        for (CharSequence charSequence : parameterTypes) {
            sig.append(charSequence);
            this.addTypeRef(charSequence.toString());
        }
        sig.append(")");
        String returnType = reference.getReturnType();
        sig.append(returnType);
        this.addExtStringRef(MethodUtil.getShorty(parameterTypes, returnType));
        this.addTypeRef(returnType);
        this.addSignatureRef(sig.toString());
    }

    private void addFieldRef(FieldReference reference, boolean isStatic) {
        this.addTypeRef(reference.getDefiningClass());
        this.addStringRef(reference.getName());
        this.addTypeRef(reference.getType());
        this.fieldRefs.add(new MyFieldRef(isStatic, reference));
    }

    private void addMethodRef(MethodReference reference, boolean isStatic) {
        this.addTypeRef(reference.getDefiningClass());
        this.addStringRef(reference.getName());
        this.addMethodSignature(reference);
        this.methodRefs.add(new MyMethodRef(isStatic, reference));
    }

    private void parseReferences(DexBackedDexFile dexFile) {
        for (ClassDef classDef : dexFile.getClasses()) {
            this.addTypeRef(classDef.getType());
            this.addTypeRef(classDef.getSuperclass());
            for (String string : classDef.getInterfaces()) {
                this.addTypeRef(string);
            }
            for (Field field : classDef.getStaticFields()) {
                this.addFieldRef(field, true);
            }
            for (Field field : classDef.getInstanceFields()) {
                this.addFieldRef(field, false);
            }
            for (Method method : classDef.getDirectMethods()) {
                this.addMethodRef(method, AccessFlags.STATIC.isSet(method.getAccessFlags()));
            }
            for (Method method : classDef.getVirtualMethods()) {
                this.addMethodRef(method, false);
            }
            for (Method method : classDef.getMethods()) {
                MethodImplementation implementation = method.getImplementation();
                if (implementation == null) continue;
                this.collectReferences(implementation);
            }
        }
        this.makeStringPool();
        this.makeTypePool();
        this.makeFieldPool();
        this.makeMethodPool();
        this.makeSignaturePool();
        this.makeClassNamePool();
        ArrayList<String> stringPool = this.stringPool;
        HashMap<String, Integer> hashMap = this.stringPoolIndexMap;
        for (String string : this.extStringRefs) {
            if (hashMap.containsKey(string)) continue;
            stringPool.add(string);
            hashMap.put(string, stringPool.size() - 1);
        }
        this.makeConstStringPool();
    }

    private void collectReferences(MethodImplementation implementation) {
        for (Instruction instruction : implementation.getInstructions()) {
            switch (instruction.getOpcode()) {
                case IGET_BYTE: 
                case IGET_BOOLEAN: 
                case IGET_CHAR: 
                case IGET_SHORT: 
                case IGET: 
                case IGET_WIDE: 
                case IGET_OBJECT: 
                case IPUT_BYTE: 
                case IPUT_BOOLEAN: 
                case IPUT_CHAR: 
                case IPUT_SHORT: 
                case IPUT: 
                case IPUT_WIDE: 
                case IPUT_OBJECT: {
                    Comparable<FieldReference> reference = (FieldReference)((ReferenceInstruction)instruction).getReference();
                    this.addFieldRef((FieldReference)reference, false);
                    break;
                }
                case SGET_BYTE: 
                case SGET_BOOLEAN: 
                case SGET_CHAR: 
                case SGET_SHORT: 
                case SGET: 
                case SGET_WIDE: 
                case SGET_OBJECT: {
                    Comparable<FieldReference> reference = (FieldReference)((ReferenceInstruction)instruction).getReference();
                    FieldReference fieldReference = this.analyzer.getDirectFieldRef((FieldReference)reference);
                    if (fieldReference != null) {
                        this.addFieldRef(fieldReference, true);
                        break;
                    }
                    this.addFieldRef((FieldReference)reference, true);
                    break;
                }
                case SPUT_BYTE: 
                case SPUT_BOOLEAN: 
                case SPUT_CHAR: 
                case SPUT_SHORT: 
                case SPUT: 
                case SPUT_WIDE: 
                case SPUT_OBJECT: {
                    Comparable<FieldReference> reference = (FieldReference)((ReferenceInstruction)instruction).getReference();
                    this.addFieldRef((FieldReference)reference, true);
                    break;
                }
                case CONST_STRING: 
                case CONST_STRING_JUMBO: {
                    Comparable<FieldReference> reference = (StringReference)((ReferenceInstruction)instruction).getReference();
                    this.addConstStringRef(reference.getString());
                    break;
                }
                case CONST_CLASS: 
                case CHECK_CAST: 
                case INSTANCE_OF: 
                case NEW_INSTANCE: 
                case NEW_ARRAY: 
                case FILLED_NEW_ARRAY: 
                case FILLED_NEW_ARRAY_RANGE: {
                    Comparable<FieldReference> reference = (TypeReference)((ReferenceInstruction)instruction).getReference();
                    this.addTypeRef(reference.getType());
                    break;
                }
                case INVOKE_STATIC: 
                case INVOKE_STATIC_RANGE: {
                    Comparable<FieldReference> reference = (MethodReference)((ReferenceInstruction)instruction).getReference();
                    this.addMethodRef((MethodReference)reference, true);
                    break;
                }
                case INVOKE_DIRECT: 
                case INVOKE_DIRECT_RANGE: 
                case INVOKE_SUPER: 
                case INVOKE_SUPER_RANGE: 
                case INVOKE_INTERFACE: 
                case INVOKE_INTERFACE_RANGE: 
                case INVOKE_VIRTUAL: 
                case INVOKE_VIRTUAL_RANGE: {
                    Comparable<FieldReference> reference = (MethodReference)((ReferenceInstruction)instruction).getReference();
                    this.addMethodRef((MethodReference)reference, false);
                    break;
                }
                case INVOKE_CUSTOM: 
                case INVOKE_CUSTOM_RANGE: 
                case INVOKE_POLYMORPHIC: 
                case INVOKE_POLYMORPHIC_RANGE: {
                    throw new RuntimeException("Unsupported opcode\uff1a " + (Object)((Object)instruction.getOpcode()));
                }
            }
            for (TryBlock<? extends ExceptionHandler> tryBlock : implementation.getTryBlocks()) {
                for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                    this.addTypeRef(exceptionHandler.getExceptionType());
                }
            }
        }
    }

    private void makeStringPool() {
        ArrayList<String> stringPool = this.stringPool;
        stringPool.addAll(this.stringRefs);
        Collections.sort(stringPool);
        for (int i11 = 0; i11 < stringPool.size(); ++i11) {
            String str = stringPool.get(i11);
            this.stringPoolIndexMap.put(str, i11);
        }
    }

    public int getStringItemIndex(String str) {
        Integer integer = this.stringPoolIndexMap.get(str);
        if (integer == null) {
            throw new RuntimeException("unknown string ref: " + str);
        }
        return integer;
    }

    public List<String> getStringPool() {
        return this.stringPool;
    }

    private void makeConstStringPool() {
        this.constStringPool.addAll(this.constantStrings);
        Collections.sort(this.constStringPool);
        for (int i11 = 0; i11 < this.constStringPool.size(); ++i11) {
            this.constStringPoolIndexMap.put(this.constStringPool.get(i11), i11);
        }
    }

    public List<String> getConstantStringPool() {
        return this.constStringPool;
    }

    public int getConstStringItemIndex(String constString) {
        Integer integer = this.constStringPoolIndexMap.get(constString);
        if (integer == null) {
            throw new RuntimeException("unknown constString ref: " + constString);
        }
        return integer;
    }

    private void makeTypePool() {
        ArrayList<String> typePool = this.typePool;
        typePool.addAll(this.typeRefs);
        Collections.sort(typePool);
        for (int i11 = 0; i11 < typePool.size(); ++i11) {
            this.typePoolIndexMap.put(typePool.get(i11), i11);
        }
    }

    public int getTypeItemIndex(String type) {
        Integer integer = this.typePoolIndexMap.get(type);
        if (integer == null) {
            throw new RuntimeException("unknown type ref: " + type);
        }
        return integer;
    }

    public List<String> getTypePool() {
        return this.typePool;
    }

    public int getMaxTypeLen() {
        if (this.maxTypeLen == 0) {
            for (String type : this.typePool) {
                int countBytes;
                try {
                    countBytes = (int)ModifiedUtf8.countBytes(type, true);
                }
                catch (UTFDataFormatException e11) {
                    throw new RuntimeException(e11);
                }
                this.maxTypeLen = Math.max(this.maxTypeLen, countBytes);
            }
        }
        return this.maxTypeLen;
    }

    private void makeClassNamePool() {
        for (String type : this.typePool) {
            this.classNamePool.add(References.typeToClassName(type));
        }
        for (int i11 = 0; i11 < this.classNamePool.size(); ++i11) {
            String key = this.classNamePool.get(i11);
            this.classNamePoolIndexMap.put(key, i11);
        }
    }

    public int getClassNameItemIndex(String className) {
        Integer integer = this.classNamePoolIndexMap.get(className);
        if (integer == null) {
            throw new RuntimeException("unknown class name ref: " + className);
        }
        return integer;
    }

    public List<String> getClassNamePool() {
        return this.classNamePool;
    }

    private void makeSignaturePool() {
        ArrayList<String> classNamePool = this.signaturePool;
        classNamePool.addAll(this.signatureRefs);
        Collections.sort(classNamePool);
        for (int i11 = 0; i11 < classNamePool.size(); ++i11) {
            this.signaturePoolIndexMap.put(classNamePool.get(i11), i11);
        }
    }

    public int getSignatureItemIndex(String sig) {
        Integer integer = this.signaturePoolIndexMap.get(sig);
        if (integer == null) {
            throw new RuntimeException("unknown signature ref: " + sig);
        }
        return integer;
    }

    public List<String> getSignaturePool() {
        return this.signaturePool;
    }

    private void makeFieldPool() {
        ArrayList<FieldReference> fieldPool = this.fieldPool;
        for (MyFieldRef fieldRef : this.fieldRefs) {
            fieldPool.add(fieldRef.reference);
        }
        Collections.sort(fieldPool);
        for (int i11 = 0; i11 < fieldPool.size(); ++i11) {
            FieldReference reference = fieldPool.get(i11);
            this.fieldPoolIndexMap.put(reference, i11);
        }
    }

    public int getFieldItemIndex(FieldReference reference) {
        Integer integer = this.fieldPoolIndexMap.get(reference);
        if (integer == null) {
            throw new RuntimeException("unknown field ref: " + reference);
        }
        return integer;
    }

    public List<FieldReference> getFieldPool() {
        return this.fieldPool;
    }

    private void makeMethodPool() {
        ArrayList<MethodReference> methodPool = this.methodPool;
        for (MyMethodRef methodRef : this.methodRefs) {
            methodPool.add(methodRef.reference);
        }
        Collections.sort(methodPool);
        for (int i11 = 0; i11 < methodPool.size(); ++i11) {
            MethodReference reference = methodPool.get(i11);
            this.methodPoolIndexMap.put(reference, i11);
        }
    }

    public int getMethodItemIndex(MethodReference reference) {
        Integer integer = this.methodPoolIndexMap.get(reference);
        if (integer == null) {
            throw new RuntimeException("unknown method ref: " + reference);
        }
        return integer;
    }

    public List<MethodReference> getMethodPool() {
        return this.methodPool;
    }

    static class MyMethodRef {
        public final boolean isStatic;
        public final MethodReference reference;

        public MyMethodRef(boolean isStatic, MethodReference reference) {
            this.isStatic = isStatic;
            this.reference = reference;
        }

        public boolean equals(Object o11) {
            if (this == o11) {
                return true;
            }
            if (o11 == null || this.getClass() != o11.getClass()) {
                return false;
            }
            MyMethodRef that = (MyMethodRef)o11;
            return this.reference.equals(that.reference);
        }

        public int hashCode() {
            return this.reference.hashCode();
        }
    }

    static class MyFieldRef {
        public final boolean isStatic;
        public final FieldReference reference;

        public MyFieldRef(boolean isStatic, FieldReference reference) {
            this.isStatic = isStatic;
            this.reference = reference;
        }

        public boolean equals(Object o11) {
            if (this == o11) {
                return true;
            }
            if (o11 == null || this.getClass() != o11.getClass()) {
                return false;
            }
            MyFieldRef that = (MyFieldRef)o11;
            return this.reference.equals(that.reference);
        }

        public int hashCode() {
            return this.reference.hashCode();
        }
    }
}

