/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.MyMethodUtil;
import com.nmmedit.apkprotect.dex2c.converter.References;
import com.nmmedit.apkprotect.util.ModifiedUtf8;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ResolverCodeGenerator {
    private final References references;

    public ResolverCodeGenerator(DexBackedDexFile dexFile, @Nonnull ClassAnalyzer analyzer) {
        this.references = new References(dexFile, analyzer);
    }

    public References getReferences() {
        return this.references;
    }

    public void generate(Writer writer) throws IOException {
        writer.write("#include \"GlobalCache.h\"\n");
        writer.write("#include \"ConstantPool.h\"\n\n");
        writer.write("#include <pthread.h>\n\n\n");
        this.generateStringPool(writer);
        this.generateTypePool(writer);
        this.generateClassNamePool(writer);
        this.generateSignaturePool(writer);
        this.generateFieldPool(writer);
        this.generateMethodPool(writer);
        this.generateStringConstants(writer);
        this.generateResolver(writer);
    }

    private void generateStringConstants(Writer writer) throws IOException {
        References references = this.references;
        List<String> constantStringPool = references.getConstantStringPool();
        int[] constStringIds = new int[constantStringPool.size()];
        for (int i11 = 0; i11 < constantStringPool.size(); ++i11) {
            constStringIds[i11] = references.getStringItemIndex(constantStringPool.get(i11));
        }
        writer.write("\n//\u5b57\u7b26\u4e32\u5e38\u91cf\u7d22\u5f15\u7f13\u5b58,const-string\u6307\u4ee4\u7d22\u5f15\u88ab\u91cd\u5199\uff0c\u76f4\u63a5\u6839\u636e\u7d22\u5f15\u5f97\u5230\u5b57\u7b26\u4e32\u7d22\u5f15\uff0c\u7136\u540e\u521b\u5efajstring\ntypedef struct {\n    u4 idx;\n} ConstStringId;\n");
        writer.write("static const ConstStringId gStringConstantIds[] = {\n");
        for (int offset : constStringIds) {
            writer.write(String.format("    {.idx=0x%04x},\n", offset));
        }
        writer.write("};\n");
        writer.write(String.format("static jstring gStringConstants[%d];\n\n", constStringIds.length));
    }

    private void generateResolver(Writer writer) throws IOException {
        writer.write("static void resolver_init(JNIEnv *env) {\n    if(sizeof(gFields) == 0) return;\n    if(sizeof(gMethods) == 0) return;\n    if(sizeof(gStringConstants) == 0) return;\n    memset(gFields, 0, sizeof(gFields));\n    memset(gMethods, 0, sizeof(gMethods));\n    memset(gStringConstants, 0, sizeof(gStringConstants));\n}\n\n#define STRING_BY_ID(_idx) ((const char *) (gBaseStrPtr + gStringIds[_idx].off))\n\n#define STRING_BY_TYPE_ID(_idx) (STRING_BY_ID(gTypeIds[_idx].idx))\n\n#define STRING_BY_CLASS_ID(_idx) (STRING_BY_ID(gClassIds[_idx].idx))\n\n#define STRING_BY_SIGNATURE_ID(_idx) (STRING_BY_ID(gSignatureIds[_idx].idx))\n\n#define FIND_CLASS_BY_NAME(_className)                          \\\n    clazz = (*env)->FindClass(env, _className);                 \\\n    if (clazz == NULL) {                                        \\\n        /*\u8f6c\u6362\u5f02\u5e38\u7c7b\u578b,\u4fdd\u6301\u548c\u6b63\u5e38java\u629b\u4e00\u6837\u5f02\u5e38*/                   \\\n        (*env)->ExceptionClear(env);                            \\\n        vmThrowNoClassDefFoundError(env, _className);           \\\n        return NULL;                                            \\\n    }\n\n\nstatic void vmThrowNoClassDefFoundError(JNIEnv *env, const char *msg) {\n    (*env)->ThrowNew(env, gVm.exNoClassDefFoundError, msg);\n}\n\nstatic void vmThrowNoSuchFieldError(JNIEnv *env, const char *msg) {\n    (*env)->ThrowNew(env, gVm.exNoSuchFieldError, msg);\n}\n\nstatic void vmThrowNoSuchMethodError(JNIEnv *env, const char *msg) {\n    (*env)->ThrowNew(env, gVm.exNoSuchMethodError, msg);\n}\n\nstatic const vmField *dvmResolveField(JNIEnv *env, u4 idx, bool isStatic) {\n    vmField *field = &gFields[idx];\n    if (field->fieldId == NULL) {\n        FieldId fieldId = gFieldIds[idx];\n\n        jclass clazz;\n        FIND_CLASS_BY_NAME(STRING_BY_CLASS_ID(fieldId.classIdx));\n\n        const char *type = STRING_BY_TYPE_ID(fieldId.typeIdx);\n        const char *name = STRING_BY_ID(fieldId.nameIdx);\n\n        field->classIdx = fieldId.classIdx;\n        field->type = (*type == '[') ? 'L' : *type;\n\n        //\u548c\u65b9\u6cd5\u89e3\u6790\u540c\u7406,\u6700\u540e\u8d4b\u503cfieldId\n        jfieldID fid;\n        if (isStatic) {\n            fid = (*env)->GetStaticFieldID(env, clazz, name, type);\n        } else {\n            fid = (*env)->GetFieldID(env, clazz, name, type);\n        }\n        if (fid == NULL) {\n            (*env)->DeleteLocalRef(env, clazz);\n\n            (*env)->ExceptionClear(env);\n            vmThrowNoSuchFieldError(env, name);\n            return NULL;\n        }\n        (*env)->DeleteLocalRef(env, clazz);\n\n\n        field->fieldId = fid;\n\n    }\n    return field;\n}\n\nstatic const vmMethod *dvmResolveMethod(JNIEnv *env, u4 idx, bool isStatic) {\n    vmMethod *method = &gMethods[idx];\n    if (method->methodId == NULL) {\n        MethodId methodId = gMethodIds[idx];\n\n        jclass clazz;\n        FIND_CLASS_BY_NAME(STRING_BY_CLASS_ID(methodId.classIdx));\n\n        method->shorty = STRING_BY_ID(methodId.shortyIdx);\n\n        method->classIdx = methodId.classIdx;\n\n        const char *name = STRING_BY_ID(methodId.nameIdx);\n        const char *sig = STRING_BY_SIGNATURE_ID(methodId.sigIdx);\n\n        jmethodID mid;\n        if (isStatic) {\n            mid = (*env)->GetStaticMethodID(env, clazz, name, sig);\n        } else {\n            mid = (*env)->GetMethodID(env, clazz, name, sig);\n        }\n        if (mid == NULL) {\n            (*env)->DeleteLocalRef(env, clazz);\n\n            (*env)->ExceptionClear(env);\n            vmThrowNoSuchMethodError(env, name);\n            return NULL;\n        }\n        (*env)->DeleteLocalRef(env, clazz);\n\n        //\u53ea\u6839\u636emethod->methodId\u5224\u65ad\u662f\u5426\u9700\u8981\u89e3\u6790,\u6700\u540e\u8d4b\u503c\u4e3a\u4e86\u9632\u6b62\u7ed3\u6784\u4f53\u89e3\u6790\u4e00\u534a\u88ab\u5176\u4ed6\u7ebf\u7a0b\u4f7f\u7528\u4ece\u800c\u5bfc\u81f4\u9519\u8bef\n        //todo \u8d4b\u503c\u9700\u4e3a\u539f\u5b50\u64cd\u4f5c\n\n        method->methodId = mid;\n\n    }\n    return method;\n}\n\nstatic pthread_mutex_t str_mutex = PTHREAD_MUTEX_INITIALIZER;\nstatic jstring dvmConstantString(JNIEnv *env, u4 idx) {\n    //\u5148\u67e5\u627e\u7d22\u5f15\u4f4d\u7f6e\u662f\u5426\u5b58\u5728\u7f13\u5b58,\u4e0d\u7528\u9891\u7e41\u521b\u5efastring\u5bf9\u8c61\n    if (gStringConstants[idx] == NULL) {\n        pthread_mutex_lock(&str_mutex);\n        jstring str;\n        if (gStringConstants[idx] == NULL) {\n            str = (*env)->NewStringUTF(env, STRING_BY_ID(gStringConstantIds[idx].idx));\n            gStringConstants[idx] = (*env)->NewGlobalRef(env, str);\n        } else {\n            str = (*env)->NewLocalRef(env, gStringConstants[idx]);\n        }\n        pthread_mutex_unlock(&str_mutex);\n\n        return str;\n    } else {\n        return (*env)->NewLocalRef(env, gStringConstants[idx]);\n    }\n}\n\n\nstatic const char *dvmResolveTypeUtf(JNIEnv *env, u4 idx) {\n    return STRING_BY_TYPE_ID(idx);\n}\n\nstatic jclass dvmResolveClass(JNIEnv *env, u4 idx) {\n    jclass clazz = getCacheClass(env, STRING_BY_TYPE_ID(idx));\n    if (clazz != NULL) {\n        return (jclass) (*env)->NewLocalRef(env, clazz);\n    }\n\n    FIND_CLASS_BY_NAME(STRING_BY_CLASS_ID(idx));\n\n    return clazz;\n}\n\n");
        writer.write(String.format("static jclass dvmFindClass(JNIEnv *env, const char *type) {\n    jclass clazz = getCacheClass(env, type);\n    if (clazz != NULL) {\n        return (jclass) (*env)->NewLocalRef(env, clazz);\n    }\n    if (*type == 'L') {\n        char clazzName[%d];\n        size_t len = strlen(type);\n        strncpy(clazzName, type + 1, len - 2);\n        clazzName[len - 2] = 0;\n\n        FIND_CLASS_BY_NAME(clazzName);\n\n        return clazz;\n    }\n\n    FIND_CLASS_BY_NAME(type);\n\n    return clazz;\n}\n\n", this.references.getMaxTypeLen()));
        writer.write("static const vmResolver dvmResolver = {\n        .dvmResolveField = dvmResolveField,\n        .dvmResolveMethod = dvmResolveMethod,\n        .dvmResolveTypeUtf = dvmResolveTypeUtf,\n        .dvmResolveClass = dvmResolveClass,\n        .dvmFindClass = dvmFindClass,\n        .dvmConstantString = dvmConstantString,\n};\n\n");
    }

    private void generateMethodPool(Writer writer) throws IOException {
        References references = this.references;
        writer.write("\ntypedef struct {\n    u2 classIdx;\n    u4 nameIdx;\n    u4 shortyIdx;\n    u4 sigIdx;\n} MethodId;\n\n");
        writer.write("static const MethodId gMethodIds[] = {\n");
        List<MethodReference> methodPool = references.getMethodPool();
        for (MethodReference methodReference : methodPool) {
            String definingClass = methodReference.getDefiningClass();
            String className = definingClass.charAt(0) == 'L' ? definingClass.substring(1, definingClass.length() - 1) : definingClass;
            int classNameIdx = references.getClassNameItemIndex(className);
            if (classNameIdx < 0) {
                throw new RuntimeException("unknown class name" + definingClass);
            }
            String name = methodReference.getName();
            int nameIdx = references.getStringItemIndex(name);
            if (nameIdx < 0) {
                throw new RuntimeException("unknown method name");
            }
            int shortyIdx = references.getStringItemIndex(MethodUtil.getShorty(methodReference.getParameterTypes(), methodReference.getReturnType()));
            if (shortyIdx < 0) {
                throw new RuntimeException("unknown method shorty");
            }
            String signature = MyMethodUtil.getMethodSignature(methodReference.getParameterTypes(), methodReference.getReturnType());
            int sigIdx = references.getSignatureItemIndex(signature);
            if (sigIdx < 0) {
                throw new RuntimeException("unknown method signature");
            }
            writer.write(String.format("    {.classIdx=%d, .nameIdx=%d, .shortyIdx=%d, .sigIdx=%d},\n", classNameIdx, nameIdx, shortyIdx, sigIdx));
        }
        writer.write("};\n");
        writer.write("//ends method data\n\n");
        writer.write(String.format("static vmMethod gMethods[%d];\n", methodPool.size()));
        writer.write("\n");
    }

    private void generateFieldPool(Writer writer) throws IOException {
        References references = this.references;
        writer.write("\ntypedef struct {\n    u2 classIdx;\n    u4 nameIdx;\n    u2 typeIdx;\n} FieldId;\n\n");
        writer.write("static const FieldId gFieldIds[] = {\n");
        List<FieldReference> fieldPool = references.getFieldPool();
        for (FieldReference reference : fieldPool) {
            String definingClass = reference.getDefiningClass();
            String className = definingClass.charAt(0) == 'L' ? definingClass.substring(1, definingClass.length() - 1) : definingClass;
            int classNameIdx = references.getClassNameItemIndex(className);
            if (classNameIdx < 0) {
                throw new RuntimeException("unknown class name");
            }
            int nameIdx = references.getStringItemIndex(reference.getName());
            if (nameIdx < 0) {
                throw new RuntimeException("unknown field name");
            }
            int typeIdx = references.getTypeItemIndex(reference.getType());
            if (typeIdx < 0) {
                throw new RuntimeException("unknown field type");
            }
            writer.write(String.format("    {.classIdx=%d, .nameIdx=%d, .typeIdx=%d},\n", classNameIdx, nameIdx, typeIdx));
        }
        writer.write("};\n");
        writer.write("//ends field id\n\n");
        writer.write(String.format("static vmField gFields[%d];\n", fieldPool.size()));
    }

    private void generateStringPool(Writer writer) throws IOException {
        writer.write("static const u1 gBaseStrPtr[]={\n");
        ArrayList<Long> strOffsets = new ArrayList<Long>();
        long strOffset = 0L;
        List<String> stringPool = this.references.getStringPool();
        for (String string : stringPool) {
            byte[] bytes = ModifiedUtf8.encode(string);
            writer.write("    ");
            for (byte aByte : bytes) {
                writer.write(String.format("0x%02x,", aByte & 0xFF));
            }
            writer.write("0x00,\n");
            strOffsets.add(strOffset);
            strOffset += (long)(bytes.length + 1);
        }
        writer.write("};\n\n");
        writer.write("\ntypedef struct {\n    u4 off;\n} StringId;\n");
        writer.write("static const StringId gStringIds[] = {\n");
        for (Long offset : strOffsets) {
            if (offset > 0xFFFFFFFFL) {
                throw new RuntimeException("string offset too long");
            }
            writer.write(String.format("    {.off=0x%04x},\n", offset));
        }
        writer.write("};\n");
        writer.write("//ends string ids\n\n");
        writer.flush();
    }

    static String stringEsc(String str) throws UTFDataFormatException {
        byte[] bytes = ModifiedUtf8.encode(str);
        StringBuilder sb2 = new StringBuilder(4 * bytes.length);
        for (byte b11 : bytes) {
            sb2.append(String.format("\\x%02x", b11 & 0xFF));
        }
        return sb2.toString();
    }

    private void generateTypePool(Writer writer) throws IOException {
        writer.write("\ntypedef struct {\n    u4 idx;\n} TypeId;\n");
        writer.write("static const TypeId gTypeIds[] = {\n");
        References references = this.references;
        for (String type : references.getTypePool()) {
            writer.write(String.format("    {.idx=%d},\n", references.getStringItemIndex(type)));
        }
        writer.write("};\n");
        writer.write("//ends type ids\n\n");
        writer.flush();
    }

    private void generateClassNamePool(Writer writer) throws IOException {
        writer.write("\ntypedef struct {\n    u4 idx;\n} ClassId;\n");
        writer.write("static const ClassId gClassIds[] = {\n");
        References references = this.references;
        for (String className : references.getClassNamePool()) {
            int classNameIdx = references.getStringItemIndex(className);
            if (classNameIdx < 0) {
                throw new RuntimeException("string not contain");
            }
            writer.write(String.format("    {.idx=%d},\n", classNameIdx));
        }
        writer.write("};\n");
        writer.write("//ends class name ids\n\n");
    }

    private void generateSignaturePool(Writer writer) throws IOException {
        writer.write("typedef struct {\n    u4 idx;\n} SignatureId;\n");
        writer.write("static const SignatureId gSignatureIds[] = {\n");
        References references = this.references;
        for (String sig : references.getSignaturePool()) {
            int sigIdx = references.getStringItemIndex(sig);
            if (sigIdx < 0) {
                throw new RuntimeException("string not contain");
            }
            writer.write(String.format("    {.idx=%d},\n", sigIdx));
        }
        writer.write("};\n");
        writer.write("//ends method signature pool\n\n");
    }
}

