/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter.instructionrewriter;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.iface.ExceptionHandler;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.TryBlock;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.SwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.ArrayPayload;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction10t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction10x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction11n;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction11x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction12x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction20bc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction20t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21ih;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21lh;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21s;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22b;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22cs;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22s;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction23x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction30t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31i;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction32x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction35c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction3rc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction51l;
import com.android.tools.smali.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.android.tools.smali.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.StringReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.writer.DexDataWriter;
import com.android.tools.smali.util.ExceptionWithContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.References;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class InstructionRewriter {
    final Opcodes opcodes;
    private References references;
    private ClassAnalyzer classAnalyzer;
    private final Comparator<SwitchElement> switchElementComparator = new Comparator<SwitchElement>(){

        @Override
        public int compare(SwitchElement element1, SwitchElement element2) {
            return Ints.compare(element1.getKey(), element2.getKey());
        }
    };

    public InstructionRewriter(@Nonnull Opcodes opcodes) {
        this.opcodes = opcodes;
    }

    public void loadReferences(@Nonnull References references, @Nonnull ClassAnalyzer classAnalyzer) {
        this.references = references;
        this.classAnalyzer = classAnalyzer;
    }

    public abstract int replaceOpcode(Opcode var1);

    @Nonnull
    protected abstract List<Opcode> getOpcodeList();

    public final void generateConfig(Writer opcodeWriter, Writer gotoTableWriter) throws IOException {
        List<Opcode> opcodeList = this.getOpcodeList();
        for (int i11 = 0; i11 < opcodeList.size(); ++i11) {
            String opName;
            Opcode opcode = opcodeList.get(i11);
            if (opcode != null) {
                opName = opcode.name.replace('-', '_').replace('/', '_').toUpperCase();
                opcodeWriter.write(String.format("    OP_%s     = 0x%x,\n", opName, i11));
                gotoTableWriter.write(String.format("    H(OP_%s),                                                            \\\\\n", opName));
                continue;
            }
            opName = String.format("OP_UNUSED_%02x", i11).toUpperCase();
            opcodeWriter.write(String.format("    %s     = 0x%02x,\n", opName, i11));
            gotoTableWriter.write(String.format("    H(%s),                                                            \\\\\n", opName));
        }
    }

    public final byte[] rewriteInstructions(MethodImplementation methodImp) {
        if (methodImp == null) {
            throw new RuntimeException("No methodImp");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DexDataWriter writer = new DexDataWriter(out, 0);
        for (Instruction instruction : methodImp.getInstructions()) {
            switch (instruction.getOpcode().format) {
                case Format10t: {
                    this.write(writer, (Instruction10t)instruction);
                    break;
                }
                case Format10x: {
                    this.write(writer, (Instruction10x)instruction);
                    break;
                }
                case Format11n: {
                    this.write(writer, (Instruction11n)instruction);
                    break;
                }
                case Format11x: {
                    this.write(writer, (Instruction11x)instruction);
                    break;
                }
                case Format12x: {
                    this.write(writer, (Instruction12x)instruction);
                    break;
                }
                case Format20bc: {
                    this.write(writer, (Instruction20bc)instruction);
                    break;
                }
                case Format20t: {
                    this.write(writer, (Instruction20t)instruction);
                    break;
                }
                case Format21c: {
                    this.write(writer, (Instruction21c)instruction);
                    break;
                }
                case Format21ih: {
                    this.write(writer, (Instruction21ih)instruction);
                    break;
                }
                case Format21lh: {
                    this.write(writer, (Instruction21lh)instruction);
                    break;
                }
                case Format21s: {
                    this.write(writer, (Instruction21s)instruction);
                    break;
                }
                case Format21t: {
                    this.write(writer, (Instruction21t)instruction);
                    break;
                }
                case Format22b: {
                    this.write(writer, (Instruction22b)instruction);
                    break;
                }
                case Format22c: {
                    this.write(writer, (Instruction22c)instruction);
                    break;
                }
                case Format22cs: {
                    this.write(writer, (Instruction22cs)instruction);
                    break;
                }
                case Format22s: {
                    this.write(writer, (Instruction22s)instruction);
                    break;
                }
                case Format22t: {
                    this.write(writer, (Instruction22t)instruction);
                    break;
                }
                case Format22x: {
                    this.write(writer, (Instruction22x)instruction);
                    break;
                }
                case Format23x: {
                    this.write(writer, (Instruction23x)instruction);
                    break;
                }
                case Format30t: {
                    this.write(writer, (Instruction30t)instruction);
                    break;
                }
                case Format31c: {
                    this.write(writer, (Instruction31c)instruction);
                    break;
                }
                case Format31i: {
                    this.write(writer, (Instruction31i)instruction);
                    break;
                }
                case Format31t: {
                    this.write(writer, (Instruction31t)instruction);
                    break;
                }
                case Format32x: {
                    this.write(writer, (Instruction32x)instruction);
                    break;
                }
                case Format35c: {
                    this.write(writer, (Instruction35c)instruction);
                    break;
                }
                case Format35mi: {
                    break;
                }
                case Format35ms: {
                    break;
                }
                case Format3rc: {
                    this.write(writer, (Instruction3rc)instruction);
                    break;
                }
                case Format3rmi: {
                    break;
                }
                case Format3rms: {
                    break;
                }
                case Format45cc: {
                    break;
                }
                case Format4rcc: {
                    break;
                }
                case Format51l: {
                    this.write(writer, (Instruction51l)instruction);
                    break;
                }
                case ArrayPayload: {
                    this.write(writer, (ArrayPayload)instruction);
                    break;
                }
                case PackedSwitchPayload: {
                    this.write(writer, (PackedSwitchPayload)instruction);
                    break;
                }
                case SparseSwitchPayload: {
                    this.write(writer, (SparseSwitchPayload)instruction);
                    break;
                }
                case UnresolvedOdexInstruction: {
                    throw new RuntimeException("Don't support odex");
                }
            }
        }
        try {
            writer.close();
        }
        catch (IOException e11) {
            throw new RuntimeException(e11);
        }
        return out.toByteArray();
    }

    @Nonnull
    public final byte[] handleTries(MethodImplementation methodImp) throws IOException {
        if (methodImp == null) {
            throw new RuntimeException("No methodImp");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DexDataWriter writer = new DexDataWriter(out, 0);
        List<? extends TryBlock<? extends ExceptionHandler>> tryBlocks = methodImp.getTryBlocks();
        if (tryBlocks.size() > 0) {
            writer.writeUshort(tryBlocks.size());
            writer.writeUshort(0);
            ByteArrayOutputStream ehBuf = new ByteArrayOutputStream();
            HashMap<List<? extends ExceptionHandler>, Integer> exceptionHandlerOffsetMap = Maps.newHashMap();
            for (TryBlock<? extends ExceptionHandler> tryBlock : tryBlocks) {
                exceptionHandlerOffsetMap.put(tryBlock.getExceptionHandlers(), 0);
            }
            DexDataWriter.writeUleb128(ehBuf, exceptionHandlerOffsetMap.size());
            for (TryBlock<? extends ExceptionHandler> tryBlock : tryBlocks) {
                int startAddress = tryBlock.getStartCodeAddress();
                int endAddress = startAddress + tryBlock.getCodeUnitCount();
                int tbCodeUnitCount = endAddress - startAddress;
                writer.writeInt(startAddress);
                writer.writeUshort(tbCodeUnitCount);
                if (tryBlock.getExceptionHandlers().size() == 0) {
                    throw new ExceptionWithContext("No exception handlers for the try block!", new Object[0]);
                }
                Integer offset = (Integer)exceptionHandlerOffsetMap.get(tryBlock.getExceptionHandlers());
                if (offset != 0) {
                    writer.writeUshort(offset);
                    continue;
                }
                offset = ehBuf.size();
                writer.writeUshort(offset);
                exceptionHandlerOffsetMap.put(tryBlock.getExceptionHandlers(), offset);
                int ehSize = tryBlock.getExceptionHandlers().size();
                ExceptionHandler ehLast = tryBlock.getExceptionHandlers().get(ehSize - 1);
                if (ehLast.getExceptionType() == null) {
                    ehSize = ehSize * -1 + 1;
                }
                DexDataWriter.writeSleb128(ehBuf, ehSize);
                for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                    TypeReference exceptionTypeReference = exceptionHandler.getExceptionTypeReference();
                    int codeAddress = exceptionHandler.getHandlerCodeAddress();
                    if (exceptionTypeReference != null) {
                        DexDataWriter.writeUleb128(ehBuf, this.getReferenceIndex(1, exceptionTypeReference));
                        DexDataWriter.writeUleb128(ehBuf, codeAddress);
                        continue;
                    }
                    DexDataWriter.writeUleb128(ehBuf, codeAddress);
                }
            }
            if (ehBuf.size() > 0) {
                ehBuf.writeTo(writer);
                ehBuf.reset();
            }
        }
        try {
            writer.close();
        }
        catch (IOException e11) {
            throw new RuntimeException(e11);
        }
        return out.toByteArray();
    }

    private short getOpcodeValue(Opcode opcode) {
        Short value = this.opcodes.getOpcodeValue(opcode);
        if (value == null) {
            throw new ExceptionWithContext("Instruction %s is invalid for api %d", opcode.name, this.opcodes.api);
        }
        if (value > 255) {
            return value;
        }
        return (short)this.replaceOpcode(opcode);
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction10t instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getCodeOffset());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction10x instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(0);
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction11n instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterA(), instruction.getNarrowLiteral()));
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction11x instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction12x instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction20bc instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getVerificationError());
            writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction20t instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(0);
            writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction21c instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction21ih instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction21lh instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction21s instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction21t instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction22b instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.write(instruction.getRegisterB());
            writer.write(instruction.getNarrowLiteral());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction22c instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction22cs instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            writer.writeUshort(instruction.getFieldOffset());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction22s instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction22t instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction22x instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction23x instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.write(instruction.getRegisterB());
            writer.write(instruction.getRegisterC());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction30t instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(0);
            writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction31c instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeInt(this.getReferenceIndex(instruction));
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction31i instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeInt(instruction.getNarrowLiteral());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction31t instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction32x instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(0);
            writer.writeUshort(instruction.getRegisterA());
            writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction35c instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            writer.writeUshort(this.getReferenceIndex(instruction));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            writer.write(InstructionRewriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction3rc instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterCount());
            writer.writeUshort(this.getReferenceIndex(instruction));
            writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull Instruction51l instruction) {
        try {
            writer.write(this.getOpcodeValue(instruction.getOpcode()));
            writer.write(instruction.getRegisterA());
            writer.writeLong(instruction.getWideLiteral());
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull ArrayPayload instruction) {
        try {
            writer.writeUshort(this.getOpcodeValue(instruction.getOpcode()));
            writer.writeUshort(instruction.getElementWidth());
            List<Number> elements = instruction.getArrayElements();
            writer.writeInt(elements.size());
            switch (instruction.getElementWidth()) {
                case 1: {
                    for (Number element : elements) {
                        writer.write(element.byteValue());
                    }
                    break;
                }
                case 2: {
                    for (Number element : elements) {
                        writer.writeShort(element.shortValue());
                    }
                    break;
                }
                case 4: {
                    for (Number element : elements) {
                        writer.writeInt(element.intValue());
                    }
                    break;
                }
                case 8: {
                    for (Number element : elements) {
                        writer.writeLong(element.longValue());
                    }
                    break;
                }
            }
            if ((writer.getPosition() & 1) != 0) {
                writer.write(0);
            }
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull SparseSwitchPayload instruction) {
        try {
            writer.writeUbyte(0);
            writer.writeUbyte(this.getOpcodeValue(instruction.getOpcode()) >> 8);
            ImmutableList<? extends SwitchElement> elements = Ordering.from(this.switchElementComparator).immutableSortedCopy(instruction.getSwitchElements());
            writer.writeUshort(elements.size());
            for (SwitchElement switchElement : elements) {
                writer.writeInt(switchElement.getKey());
            }
            for (SwitchElement switchElement : elements) {
                writer.writeInt(switchElement.getOffset());
            }
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public void write(@Nonnull DexDataWriter writer, @Nonnull PackedSwitchPayload instruction) {
        try {
            writer.writeUbyte(0);
            writer.writeUbyte(this.getOpcodeValue(instruction.getOpcode()) >> 8);
            List<? extends SwitchElement> elements = instruction.getSwitchElements();
            writer.writeUshort(elements.size());
            if (elements.size() == 0) {
                writer.writeInt(0);
            } else {
                writer.writeInt(elements.get(0).getKey());
                for (SwitchElement switchElement : elements) {
                    writer.writeInt(switchElement.getOffset());
                }
            }
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    private static int packNibbles(int a11, int b11) {
        return b11 << 4 | a11;
    }

    private int getReferenceIndex(ReferenceInstruction referenceInstruction) {
        switch (referenceInstruction.getOpcode()) {
            case SGET: 
            case SGET_BOOLEAN: 
            case SGET_BYTE: 
            case SGET_CHAR: 
            case SGET_SHORT: 
            case SGET_WIDE: 
            case SGET_OBJECT: {
                FieldReference reference = (FieldReference)referenceInstruction.getReference();
                FieldReference newFieldRef = this.classAnalyzer.getDirectFieldRef(reference);
                if (newFieldRef == null) break;
                return this.getReferenceIndex(referenceInstruction.getReferenceType(), newFieldRef);
            }
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                return this.references.getConstStringItemIndex(((StringReference)referenceInstruction.getReference()).getString());
            }
        }
        return this.getReferenceIndex(referenceInstruction.getReferenceType(), referenceInstruction.getReference());
    }

    private int getReferenceIndex(int referenceType, Reference reference) {
        switch (referenceType) {
            case 2: {
                return this.references.getFieldItemIndex((FieldReference)reference);
            }
            case 3: {
                return this.references.getMethodItemIndex((MethodReference)reference);
            }
            case 0: {
                return this.references.getStringItemIndex(((StringReference)reference).getString());
            }
            case 1: {
                return this.references.getTypeItemIndex(((TypeReference)reference).getType());
            }
        }
        throw new ExceptionWithContext("Unknown reference type: %d", referenceType);
    }
}

