/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter.instructionrewriter;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.Opcodes;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.InstructionRewriter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;

public class RandomInstructionRewriter
extends InstructionRewriter {
    private final List<Opcode> opcodeList = new ArrayList<Opcode>(256);
    private final EnumMap<Opcode, Integer> opcodeMap = new EnumMap(Opcode.class);

    public RandomInstructionRewriter() {
        super(Opcodes.forDexVersion(39));
        Opcode opcode;
        int i11;
        ArrayList<Opcode> randOpcodes = new ArrayList<Opcode>();
        for (i11 = 0; i11 < 256; ++i11) {
            opcode = this.opcodes.getOpcodeByValue(i11);
            this.opcodeList.add(opcode);
            if (opcode == null || opcode == Opcode.NOP) continue;
            randOpcodes.add(opcode);
        }
        for (i11 = 1; i11 < this.opcodeList.size(); ++i11) {
            opcode = this.opcodeList.get(i11);
            if (opcode == null) continue;
            int randIdx = new Random().nextInt(randOpcodes.size());
            Opcode remove = (Opcode)((Object)randOpcodes.remove(randIdx));
            this.opcodeList.set(i11, remove);
        }
        for (i11 = 0; i11 < this.opcodeList.size(); ++i11) {
            opcode = this.opcodeList.get(i11);
            if (opcode == null) continue;
            this.opcodeMap.put(opcode, i11);
        }
    }

    @Override
    public int replaceOpcode(Opcode opcode) {
        return this.opcodeMap.get((Object)opcode);
    }

    @Override
    @Nonnull
    protected List<Opcode> getOpcodeList() {
        return this.opcodeList;
    }
}

