/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter.structs;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.builder.MutableMethodImplementation;
import com.android.tools.smali.dexlib2.builder.instruction.BuilderInstruction10x;
import com.android.tools.smali.dexlib2.builder.instruction.BuilderInstruction11x;
import com.android.tools.smali.dexlib2.builder.instruction.BuilderInstruction35c;
import com.android.tools.smali.dexlib2.builder.instruction.BuilderInstruction3rc;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.MethodParameter;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethod;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.structs.EmptyAnnotationMethodParameter;
import com.nmmedit.apkprotect.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class MethodConverter {
    @Nonnull
    private final ClassAnalyzer classAnalyzer;

    public MethodConverter(@Nonnull ClassAnalyzer classAnalyzer) {
        this.classAnalyzer = classAnalyzer;
    }

    @Nonnull
    public Pair<List<? extends Method>, Method> convert(@Nonnull Method method) {
        if (MethodUtil.isDirect(method)) {
            return this.splitMethod(method);
        }
        MethodReference directMethod = this.classAnalyzer.findDirectMethod(method);
        if (directMethod == null) {
            return this.splitMethod(method);
        }
        return this.generateMethod(method);
    }

    private Pair<List<? extends Method>, Method> splitMethod(@Nonnull Method method) {
        return new Pair<List<? extends Method>, Method>(Collections.singletonList(MethodConverter.methodToNative(method)), method);
    }

    private static Method methodToNative(Method method) {
        return new ImmutableMethod(method.getDefiningClass(), method.getName(), (Iterable<? extends MethodParameter>)MethodConverter.removeAnnotation(method.getParameters()), method.getReturnType(), method.getAccessFlags() | AccessFlags.NATIVE.getValue(), method.getAnnotations(), method.getHiddenApiRestrictions(), null);
    }

    private String getNewMethodName(ClassDef classDef, String name, List<? extends CharSequence> parameterTypes, String returnType) {
        for (int idx = 0; idx < 65535; ++idx) {
            String newMethodName = name + idx;
            MethodReference method = this.classAnalyzer.findMethod(classDef, newMethodName, parameterTypes, returnType);
            if (method != null) continue;
            return newMethodName;
        }
        throw new RuntimeException("unknown");
    }

    private static int getResultRegisterWidth(String type) {
        char firstChar = type.charAt(0);
        if (firstChar == 'J' || firstChar == 'D') {
            return 2;
        }
        if (firstChar == 'V') {
            return 0;
        }
        return 1;
    }

    private Pair<List<? extends Method>, Method> generateMethod(@Nonnull Method method) {
        ClassDef definingClass = this.classAnalyzer.getClassDef(method.getDefiningClass());
        if (definingClass == null) {
            return this.splitMethod(method);
        }
        MethodImplementation implementation = method.getImplementation();
        if (implementation == null) {
            throw new RuntimeException("method error");
        }
        String newMethodName = this.getNewMethodName(definingClass, method.getName(), method.getParameterTypes(), method.getReturnType());
        int accessFlags = AccessFlags.PRIVATE.getValue();
        if (MethodUtil.isStatic(method)) {
            accessFlags |= AccessFlags.STATIC.getValue();
        }
        ImmutableMethod shellNativeMethod = new ImmutableMethod(method.getDefiningClass(), newMethodName, (Iterable<? extends MethodParameter>)MethodConverter.removeAnnotation(method.getParameters()), method.getReturnType(), accessFlags | AccessFlags.NATIVE.getValue(), method.getAnnotations(), method.getHiddenApiRestrictions(), null);
        ImmutableMethod implNativeMethod = new ImmutableMethod(method.getDefiningClass(), newMethodName, method.getParameters(), method.getReturnType(), accessFlags, method.getAnnotations(), method.getHiddenApiRestrictions(), implementation);
        MethodImplementation methodImpl = MethodConverter.buildCallShellNativeMethodImpl(method, shellNativeMethod);
        ImmutableMethod method1 = new ImmutableMethod(method.getDefiningClass(), method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), method.getHiddenApiRestrictions(), methodImpl);
        return new Pair<List<? extends Method>, Method>(Arrays.asList(method1, shellNativeMethod), implNativeMethod);
    }

    private static List<? extends MethodParameter> removeAnnotation(List<? extends MethodParameter> parameters) {
        ArrayList<EmptyAnnotationMethodParameter> newParameters = new ArrayList<EmptyAnnotationMethodParameter>();
        for (MethodParameter methodParameter : parameters) {
            newParameters.add(new EmptyAnnotationMethodParameter(methodParameter.getType()));
        }
        return newParameters;
    }

    private static MethodImplementation buildCallShellNativeMethodImpl(Method method, MethodReference shellNativeMethod) {
        int parameterRegisterCount = MethodUtil.getParameterRegisterCount(method);
        String returnType = method.getReturnType();
        int resultRegisterWidth = MethodConverter.getResultRegisterWidth(returnType);
        int registerCount = Math.max(resultRegisterWidth, parameterRegisterCount);
        int startReg = registerCount - parameterRegisterCount;
        MutableMethodImplementation methodImpl = new MutableMethodImplementation(registerCount);
        if (parameterRegisterCount > 5) {
            BuilderInstruction3rc instruction = new BuilderInstruction3rc(Opcode.INVOKE_DIRECT_RANGE, startReg, parameterRegisterCount, shellNativeMethod);
            methodImpl.addInstruction(instruction);
        } else {
            int regC = 0;
            int regD = 0;
            int regE = 0;
            int regF = 0;
            int regG = 0;
            switch (parameterRegisterCount) {
                case 5: {
                    regG = startReg + 4;
                }
                case 4: {
                    regF = startReg + 3;
                }
                case 3: {
                    regE = startReg + 2;
                }
                case 2: {
                    regD = startReg + 1;
                }
                case 1: {
                    regC = startReg + 0;
                }
            }
            BuilderInstruction35c instruction = new BuilderInstruction35c(Opcode.INVOKE_DIRECT, parameterRegisterCount, regC, regD, regE, regF, regG, shellNativeMethod);
            methodImpl.addInstruction(instruction);
        }
        int returnReg = 0;
        char firstChar = returnType.charAt(0);
        if (firstChar == 'J' || firstChar == 'D') {
            BuilderInstruction11x moveResult = new BuilderInstruction11x(Opcode.MOVE_RESULT_WIDE, returnReg);
            methodImpl.addInstruction(moveResult);
            BuilderInstruction11x instruction = new BuilderInstruction11x(Opcode.RETURN_WIDE, returnReg);
            methodImpl.addInstruction(instruction);
        } else if (firstChar == 'L' || firstChar == '[') {
            BuilderInstruction11x moveResult = new BuilderInstruction11x(Opcode.MOVE_RESULT_OBJECT, returnReg);
            methodImpl.addInstruction(moveResult);
            BuilderInstruction11x instruction = new BuilderInstruction11x(Opcode.RETURN_OBJECT, returnReg);
            methodImpl.addInstruction(instruction);
        } else if (firstChar == 'V') {
            BuilderInstruction10x instruction = new BuilderInstruction10x(Opcode.RETURN_VOID);
            methodImpl.addInstruction(instruction);
        } else {
            BuilderInstruction11x moveResult = new BuilderInstruction11x(Opcode.MOVE_RESULT, returnReg);
            methodImpl.addInstruction(moveResult);
            BuilderInstruction11x instruction = new BuilderInstruction11x(Opcode.RETURN, returnReg);
            methodImpl.addInstruction(instruction);
        }
        return methodImpl;
    }
}

