/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter.testbuild;

import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.nmmedit.apkprotect.dex2c.converter.MyMethodUtil;
import com.nmmedit.apkprotect.dex2c.converter.testbuild.JniTemp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassMethodImplCollection
implements ClassDef {
    private final ClassDef classDef;
    private final StringBuilder codeContent;

    public ClassMethodImplCollection(ClassDef classDef, StringBuilder sb2) {
        this.classDef = classDef;
        this.codeContent = sb2;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.classDef.getType();
    }

    @Override
    public int compareTo(@Nonnull CharSequence o11) {
        return this.classDef.compareTo(o11);
    }

    @Override
    public int getAccessFlags() {
        return this.classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.classDef.getSuperclass();
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return this.classDef.getInterfaces();
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return null;
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return this.classDef.getAnnotations();
    }

    @Override
    @Nonnull
    public Iterable<? extends Field> getStaticFields() {
        return this.classDef.getStaticFields();
    }

    @Override
    @Nonnull
    public Iterable<? extends Field> getInstanceFields() {
        return this.classDef.getInstanceFields();
    }

    @Override
    @Nonnull
    public Iterable<? extends Field> getFields() {
        return this.classDef.getFields();
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getDirectMethods() {
        Iterable<? extends Method> directMethods = this.classDef.getDirectMethods();
        return this.convertMethods(directMethods);
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getVirtualMethods() {
        Iterable<? extends Method> virtualMethods = this.classDef.getVirtualMethods();
        return this.convertMethods(virtualMethods);
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getMethods() {
        Iterable<? extends Method> methods = this.classDef.getMethods();
        return this.convertMethods(methods);
    }

    private Iterable<? extends Method> convertMethods(Iterable<? extends Method> methods) {
        ArrayList<Method> newMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (MyMethodUtil.isConstructorOrAbstract(method)) continue;
            newMethods.add(method);
            this.methodToC(method);
        }
        return newMethods;
    }

    private void methodToC(Method method) {
        MethodImplementation implementation = method.getImplementation();
        if (implementation == null) {
            return;
        }
        int registerCount = implementation.getRegisterCount();
        int parameterRegisterCount = MethodUtil.getParameterRegisterCount(method);
        List<? extends CharSequence> parameterTypes = method.getParameterTypes();
        String code = JniTemp.genJniCode(this.getType(), method.getName(), parameterTypes, MethodUtil.isStatic(method), registerCount, parameterRegisterCount, method.getReturnType());
        this.codeContent.append(code);
        this.codeContent.append('\n');
    }

    @Override
    public int length() {
        return this.classDef.length();
    }

    @Override
    public char charAt(int index) {
        return this.classDef.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.classDef.subSequence(start, end);
    }

    @Override
    public void validateReference() throws Reference.InvalidReferenceException {
        this.classDef.validateReference();
    }

    @Override
    @Nonnull
    public String toString() {
        return this.classDef.toString();
    }
}

