/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.converter.testbuild;

import java.util.List;

public class JniTemp {
    public static final String CODE_TEMP_INSNS_TRIES = "\n\n    const DexCode *dexCode = findDexCode(\"%s\", \"%s\");\n    const u2 *insns = dexCode->insns;\n    u4 insnsSize = dexCode->insnsSize;\n\n    size_t size = dexGetTryHandlerSize(dexCode);\n    const DexTry *tries = dexGetTries(dexCode);\n\n    u1 *tryHandler = (u1 *) malloc(size + 4);\n    u2 *ts = (u2 *) tryHandler;\n    ts[0] = dexCode->triesSize;\n    ts[1] = 0;\n\n    memcpy(tryHandler + 4, tries, size);\n\n    jvalue value = dvmInterpret(env, insns, insnsSize, regs, (const u1 *) tryHandler, &dvmResolver);\n    free(tryHandler);\n\n";

    public static String genJniCode(String classType, String methodName, List<? extends CharSequence> parameterTypes, boolean isStatic, int registerCount, int parameterRegisterCount, String returnType) {
        StringBuilder params = new StringBuilder();
        StringBuilder regsAss = new StringBuilder(String.format("    u8 regs[%d];\n    memset(regs, 0, sizeof(regs));\n", registerCount));
        String clazzName = classType.substring(1, classType.length() - 1);
        String jniCode = String.format("JNIEXPORT %s Java_%s_%s(JNIEnv *env, %s ", JniTemp.getJNIType(returnType), clazzName.replace('/', '_'), methodName, isStatic ? "jclass jcls" : "jobject thiz");
        int paramRegStart = registerCount - parameterRegisterCount;
        if (!isStatic) {
            regsAss.append(String.format("    regs[%d] = (u8) thiz;\n", paramRegStart++));
        }
        int size = parameterTypes.size();
        for (int i11 = 0; i11 < size; ++i11) {
            String type = parameterTypes.get(i11).toString();
            String jniType = JniTemp.getJNIType(type);
            int argNum = isStatic ? i11 : i11 + 1;
            params.append(jniType).append(" p").append(argNum);
            if (type.startsWith("[") || type.startsWith("L")) {
                regsAss.append(String.format("    regs[%d] = (u8) p%d;\n", paramRegStart++, argNum));
            } else if (type.equals("F")) {
                regsAss.append(String.format("    regs[%d] = *(u4 *) &p%d;\n", paramRegStart++, argNum));
            } else if (type.equals("D")) {
                regsAss.append(String.format("    regs[%d] = *(u8 *) &p%d;\n", paramRegStart++, argNum));
            } else {
                regsAss.append(String.format("    regs[%d] = p%d;\n", paramRegStart++, argNum));
            }
            if (type.equals("J") || type.equals("D")) {
                ++paramRegStart;
            }
            if (i11 >= size - 1) continue;
            params.append(",  ");
        }
        if (params.length() > 0) {
            jniCode = jniCode + ", " + params.toString();
        }
        jniCode = jniCode + ") {\n";
        jniCode = jniCode + regsAss;
        jniCode = jniCode + String.format(CODE_TEMP_INSNS_TRIES, classType, methodName);
        if (!returnType.equals("V")) {
            char typeCh = returnType.charAt(0);
            jniCode = jniCode + String.format("    return value.%s;\n", Character.valueOf(Character.toLowerCase(typeCh == '[' ? (char)'L' : (char)typeCh)));
        }
        jniCode = jniCode + "}\n";
        return jniCode;
    }

    public static String getJNIType(String type) {
        switch (type) {
            case "Z": {
                return "jboolean";
            }
            case "B": {
                return "jbyte";
            }
            case "S": {
                return "jshort";
            }
            case "C": {
                return "jchar";
            }
            case "I": {
                return "jint";
            }
            case "F": {
                return "jfloat";
            }
            case "J": {
                return "jlong";
            }
            case "D": {
                return "jdouble";
            }
            case "Ljava/lang/String;": {
                return "jstring";
            }
            case "V": {
                return "void";
            }
        }
        return "jobject";
    }
}

