/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.filters;

import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.nmmedit.apkprotect.deobfus.MappingProcessor;
import com.nmmedit.apkprotect.deobfus.MappingReader;
import com.nmmedit.apkprotect.dex2c.filters.ClassAndMethodFilter;
import com.nmmedit.apkprotect.dex2c.filters.SimpleRules;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ProguardMappingConfig
implements ClassAndMethodFilter,
MappingProcessor {
    private final ClassAndMethodFilter filter;
    private final Map<String, String> newTypeOldTypeMap = Maps.newHashMap();
    private final Map<String, String> oldTypeNewTypeMap = Maps.newHashMap();
    private final Set<MethodMapping> methodSet = Sets.newHashSet();
    private final HashMultimap<MethodReference, MethodReference> newMethodRefMap = HashMultimap.create();
    private final SimpleRules simpleRules;

    public ProguardMappingConfig(ClassAndMethodFilter filter, MappingReader mappingReader, SimpleRules simpleRules) throws IOException {
        this.filter = filter;
        this.simpleRules = simpleRules;
        mappingReader.parse(this);
        for (MethodMapping methodMapping : this.methodSet) {
            List<String> args = this.parseArgs(methodMapping.args);
            ImmutableMethodReference oldMethodRef = new ImmutableMethodReference(ProguardMappingConfig.javaType2jvm(methodMapping.className), methodMapping.methodName, args, ProguardMappingConfig.javaType2jvm(methodMapping.returnType));
            List<String> newArgs = this.getNewArgs(args);
            String newRetType = this.oldTypeNewTypeMap.get(methodMapping.returnType);
            if (newRetType == null) {
                newRetType = methodMapping.returnType;
            }
            ImmutableMethodReference newMethodRef = new ImmutableMethodReference(ProguardMappingConfig.javaType2jvm(methodMapping.newClassName), methodMapping.newMethodName, newArgs, ProguardMappingConfig.javaType2jvm(newRetType));
            this.newMethodRefMap.put((Object)newMethodRef, (Object)oldMethodRef);
        }
    }

    private List<String> getNewArgs(List<String> args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String arg : args) {
            String newType = this.oldTypeNewTypeMap.get(arg);
            newArgs.add(newType == null ? arg : newType);
        }
        return newArgs;
    }

    @Override
    public final boolean acceptClass(ClassDef classDef) {
        if (this.filter != null && !this.filter.acceptClass(classDef)) {
            return false;
        }
        String oldType = this.getOriginClassType(classDef.getType());
        if (oldType == null) {
            return false;
        }
        ArrayList<String> ifacs = new ArrayList<String>();
        for (String ifac : classDef.getInterfaces()) {
            ifacs.add(this.getOriginClassType(ifac));
        }
        return this.simpleRules != null && this.simpleRules.matchClass(oldType, this.getOriginClassType(classDef.getSuperclass()), ifacs);
    }

    private String getOriginClassType(String type) {
        String oldType = this.newTypeOldTypeMap.get(type);
        if (oldType == null) {
            return type;
        }
        return oldType;
    }

    @Override
    public final boolean acceptMethod(Method method) {
        if (this.filter != null && !this.filter.acceptMethod(method)) {
            return false;
        }
        String oldType = this.getOriginClassType(method.getDefiningClass());
        if (oldType == null) {
            return false;
        }
        Set oldMethodRefSet = this.newMethodRefMap.get((Object)method);
        for (MethodReference reference : oldMethodRefSet) {
            if (!oldType.equals(reference.getDefiningClass()) || this.simpleRules == null || !this.simpleRules.matchMethod(reference.getName())) continue;
            return true;
        }
        return this.simpleRules != null && this.simpleRules.matchMethod(method.getName());
    }

    private static String classNameToType(String className) {
        return "L" + className.replace('.', '/') + ";";
    }

    @Override
    public final void processClassMapping(String className, String newClassName) {
        this.newTypeOldTypeMap.put(ProguardMappingConfig.classNameToType(newClassName), ProguardMappingConfig.classNameToType(className));
        this.oldTypeNewTypeMap.put(ProguardMappingConfig.classNameToType(className), ProguardMappingConfig.classNameToType(newClassName));
    }

    @Override
    public final void processFieldMapping(String className, String fieldType, String fieldName, String newClassName, String newFieldName) {
    }

    @Nonnull
    private static String javaType2jvm(@Nonnull String type) {
        switch (type.trim()) {
            case "boolean": {
                return "Z";
            }
            case "byte": {
                return "B";
            }
            case "char": {
                return "C";
            }
            case "short": {
                return "S";
            }
            case "int": {
                return "I";
            }
            case "float": {
                return "F";
            }
            case "long": {
                return "J";
            }
            case "double": {
                return "D";
            }
            case "void": {
                return "V";
            }
        }
        int i11 = type.indexOf(91);
        if (i11 != -1) {
            String t11 = type.substring(0, i11);
            StringBuilder arr = new StringBuilder("[");
            while ((i11 = type.indexOf(91, i11 + 1)) != -1) {
                arr.append('[');
            }
            arr.append(ProguardMappingConfig.javaType2jvm(t11));
            return arr.toString();
        }
        return ProguardMappingConfig.classNameToType(type);
    }

    @Nonnull
    private List<String> parseArgs(String methodArgs) {
        String[] split;
        ArrayList<String> args = new ArrayList<String>();
        if ("".equals(methodArgs)) {
            return args;
        }
        for (String type : split = methodArgs.split(",")) {
            args.add(ProguardMappingConfig.javaType2jvm(type));
        }
        return args;
    }

    @Override
    public final void processMethodMapping(String className, int firstLineNumber, int lastLineNumber, String methodReturnType, String methodName, String methodArguments, String newClassName, int newFirstLineNumber, int newLastLineNumber, String newMethodName) {
        MethodMapping mapping = new MethodMapping(className, methodName, newClassName, newMethodName, methodArguments, methodReturnType);
        this.methodSet.add(mapping);
    }

    private static class MethodMapping {
        private final String className;
        private final String methodName;
        private final String newClassName;
        private final String newMethodName;
        private final String args;
        private final String returnType;

        public MethodMapping(String className, String methodName, String newClassName, String newMethodName, String args, String returnType) {
            this.className = className;
            this.methodName = methodName;
            this.newClassName = newClassName;
            this.newMethodName = newMethodName;
            this.args = args;
            this.returnType = returnType;
        }

        public boolean equals(Object o11) {
            if (this == o11) {
                return true;
            }
            if (o11 == null || this.getClass() != o11.getClass()) {
                return false;
            }
            MethodMapping that = (MethodMapping)o11;
            if (!this.className.equals(that.className)) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            if (!this.newClassName.equals(that.newClassName)) {
                return false;
            }
            if (!this.newMethodName.equals(that.newMethodName)) {
                return false;
            }
            if (!this.args.equals(that.args)) {
                return false;
            }
            return this.returnType.equals(that.returnType);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + this.newClassName.hashCode();
            result = 31 * result + this.newMethodName.hashCode();
            result = 31 * result + this.args.hashCode();
            result = 31 * result + this.returnType.hashCode();
            return result;
        }
    }
}

