/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.dex2c.filters;

import com.google.common.collect.HashMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleRules {
    private final HashMultimap<ClassRule, MethodRule> convertRules = HashMultimap.create();
    private Set<MethodRule> methodRules;

    public void parse(Reader ruleReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(ruleReader);){
            String line;
            ClassRule classRule = null;
            ArrayList<String> methodNameList = new ArrayList<String>();
            boolean methodParsing = false;
            int lineNumb = 0;
            while ((line = reader.readLine()) != null) {
                if ("".equals(line = line.trim())) {
                    ++lineNumb;
                    continue;
                }
                if (line.startsWith("class")) {
                    String[] split = line.split(" +");
                    int length = split.length;
                    if (length < 2) {
                        throw new RemoteException("Error rule " + lineNumb + ": " + line);
                    }
                    String className = split[1];
                    String supperName = "";
                    String interfaceName = "";
                    if (length >= 4) {
                        if ("extends".equals(split[2])) {
                            supperName = split[3];
                        } else if ("implements".equals(split[2])) {
                            interfaceName = split[3];
                        }
                    }
                    classRule = new ClassRule(className, supperName, interfaceName);
                    int mstart = line.indexOf(123);
                    if (mstart != -1) {
                        int mend = line.indexOf(125);
                        if (mend != -1) {
                            String[] methodNames = line.substring(mstart + 1, mend).trim().split(";");
                            if (methodNames.length == 0) {
                                throw new RemoteException("Error rule " + lineNumb + ": " + line);
                            }
                            for (String name : methodNames) {
                                this.convertRules.put((Object)classRule, (Object)new MethodRule(name));
                            }
                        } else {
                            methodNameList.clear();
                            methodParsing = true;
                        }
                    } else {
                        this.convertRules.put((Object)classRule, (Object)new MethodRule("*"));
                    }
                } else if (methodParsing) {
                    if (line.indexOf(125) != -1) {
                        if (methodNameList.isEmpty()) {
                            throw new RemoteException("Error rule " + lineNumb + ": " + line);
                        }
                        for (String methodName : methodNameList) {
                            if ("".equals(methodName)) continue;
                            this.convertRules.put((Object)classRule, (Object)new MethodRule(methodName));
                        }
                        methodParsing = false;
                    } else {
                        methodNameList.add(line.replace(";", ""));
                    }
                } else {
                    throw new RemoteException("Error rule " + lineNumb + ": " + line);
                }
                ++lineNumb;
            }
        }
    }

    public boolean matchClass(@Nonnull String classType, @Nullable String supperType, @Nonnull List<String> ifacTypes) {
        for (ClassRule rule : this.convertRules.keySet()) {
            String typeRegex = SimpleRules.toRegex(SimpleRules.classNameToType(rule.className));
            if (!classType.matches(typeRegex)) continue;
            if (!"".equals(rule.supperName)) {
                String type;
                if (supperType == null || !supperType.equals(type = SimpleRules.classNameToType(rule.supperName))) continue;
                this.methodRules = this.convertRules.get((Object)rule);
                return true;
            }
            if (!"".equals(rule.interfaceName)) {
                for (String iface : ifacTypes) {
                    if (!iface.equals(SimpleRules.classNameToType(rule.interfaceName))) continue;
                    this.methodRules = this.convertRules.get((Object)rule);
                    return true;
                }
                continue;
            }
            this.methodRules = this.convertRules.get((Object)rule);
            return true;
        }
        this.methodRules = null;
        return false;
    }

    public boolean matchMethod(String methodName) {
        if (this.methodRules == null || methodName == null) {
            return false;
        }
        for (MethodRule methodRule : this.methodRules) {
            if (!methodName.matches(SimpleRules.toRegex(methodRule.methodName))) continue;
            return true;
        }
        return false;
    }

    private static String classNameToType(String className) {
        return "L" + className.replace('.', '/') + ";";
    }

    @Nonnull
    private static String toRegex(String s11) {
        StringBuilder sb2 = new StringBuilder(s11.length() + 3);
        for (int i11 = 0; i11 < s11.length(); ++i11) {
            char c11 = s11.charAt(i11);
            switch (c11) {
                case '*': {
                    sb2.append('.');
                }
            }
            sb2.append(c11);
        }
        return sb2.toString();
    }

    private static class MethodRule {
        @Nonnull
        private final String methodName;

        public MethodRule(@Nonnull String methodName) {
            this.methodName = methodName;
        }
    }

    private static class ClassRule {
        @Nonnull
        private final String className;
        @Nonnull
        private final String supperName;
        @Nonnull
        private final String interfaceName;

        public ClassRule(@Nonnull String className) {
            this(className, "", "");
        }

        public ClassRule(@Nonnull String className, @Nonnull String supperName, @Nonnull String interfaceName) {
            this.className = className;
            this.supperName = supperName;
            this.interfaceName = interfaceName;
        }

        public boolean equals(Object o11) {
            if (this == o11) {
                return true;
            }
            if (o11 == null || this.getClass() != o11.getClass()) {
                return false;
            }
            ClassRule classRule = (ClassRule)o11;
            if (!this.className.equals(classRule.className)) {
                return false;
            }
            if (!this.supperName.equals(classRule.supperName)) {
                return false;
            }
            return this.interfaceName.equals(classRule.interfaceName);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.supperName.hashCode();
            result = 31 * result + this.interfaceName.hashCode();
            return result;
        }
    }
}

