/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.sign;

import com.nmmedit.apkprotect.sign.PublicKeyUtils;

public class ApkVerifyCodeGenerator {
    private final String keyStorePath;
    private final String alias;
    private final String keyStorePassword;

    public ApkVerifyCodeGenerator(String keyStorePath, String alias, String keyStorePassword) {
        this.keyStorePath = keyStorePath;
        this.alias = alias;
        this.keyStorePassword = keyStorePassword;
    }

    public String generate() {
        byte[] publicKey = PublicKeyUtils.getPublicKey(this.keyStorePath, this.alias, this.keyStorePassword);
        if (publicKey == null) {
            throw new RuntimeException("publicKey == null");
        }
        StringBuilder sb2 = new StringBuilder("");
        for (int i11 = 0; i11 < publicKey.length; ++i11) {
            if (i11 % 10 == 0) {
                sb2.append("    \\\\\n    ");
            }
            sb2.append(String.format("0x%02x, ", publicKey[i11] & 0xFF));
        }
        return sb2.toString();
    }
}

