/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.sign;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class PublicKeyUtils {
    public static byte[] getPublicKey(String keyStorePath, String alias, String password) {
        try {
            Certificate[] chain;
            KeyStore ks2 = KeyStore.getInstance(KeyStore.getDefaultType());
            ks2.load(new FileInputStream(keyStorePath), password.toCharArray());
            if (alias == null || "".equals(alias)) {
                Enumeration<String> aliases = ks2.aliases();
                if (aliases == null) {
                    return null;
                }
                if (aliases.hasMoreElements()) {
                    alias = aliases.nextElement();
                }
            }
            if ((chain = ks2.getCertificateChain(alias)) == null || chain.length == 0) {
                throw new RuntimeException(keyStorePath + " entry \"" + alias + "\" does not contain certificates");
            }
            PublicKey publicKey = chain[0].getPublicKey();
            return publicKey.getEncoded();
        }
        catch (Exception e11) {
            throw new RuntimeException(e11);
        }
    }
}

