/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.util;

import com.android.zipflinger.ZipArchive;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public final class ApkUtils {
    private ApkUtils() {
    }

    public static byte[] getFile(File apkFile, String filename) throws IOException {
        try (ZipArchive apkZip = new ZipArchive(apkFile.toPath());){
            byte[] byArray;
            block13: {
                InputStream input = apkZip.getInputStream(filename);
                if (input == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                InputStream in2 = input;
                try {
                    byArray = ApkUtils.toByteArray(in2);
                    if (in2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in2.close();
            }
            return byArray;
        }
    }

    private static byte[] toByteArray(InputStream in2) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((len = in2.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        return baos.toByteArray();
    }

    public static void copyStream(InputStream in2, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in2.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static List<File> extractFiles(File apkFile, String regex, File outDir) throws IOException {
        return ApkUtils.extractFiles(apkFile, Pattern.compile(regex), outDir);
    }

    public static List<File> extractFiles(File apkFile, Pattern regex, File outDir) throws IOException {
        try (ZipArchive apkZip = new ZipArchive(apkFile.toPath());){
            LinkedList<File> result = new LinkedList<File>();
            for (String entry : apkZip.listEntries()) {
                InputStream input;
                if (!regex.matcher(entry).matches() || (input = apkZip.getInputStream(entry)) == null) continue;
                File file = new File(outDir, entry);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                InputStream in2 = input;
                try (FileOutputStream output = new FileOutputStream(file);){
                    ApkUtils.copyStream(in2, output);
                    result.add(file);
                }
                finally {
                    if (in2 == null) continue;
                    in2.close();
                }
            }
            LinkedList<File> linkedList = result;
            return linkedList;
        }
    }
}

