/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.util;

import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.InstructionRewriter;
import com.nmmedit.apkprotect.sign.ApkVerifyCodeGenerator;
import com.nmmedit.apkprotect.util.ApkUtils;
import com.nmmedit.apkprotect.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CmakeUtils {
    public static void writeOpcodeHeaderFile(File source, InstructionRewriter instructionRewriter) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), StandardCharsets.UTF_8));
        String collect = bufferedReader.lines().collect(Collectors.joining("\n"));
        Pattern opcodePattern = Pattern.compile("enum Opcode \\{.*?};", 40);
        StringWriter opcodeContent = new StringWriter();
        StringWriter gotoTableContent = new StringWriter();
        instructionRewriter.generateConfig(opcodeContent, gotoTableContent);
        String headerContent = opcodePattern.matcher(collect).replaceAll(String.format("enum Opcode {\n%s};\n", opcodeContent.toString()));
        Pattern patternGotoTable = Pattern.compile("_name\\[kNumPackedOpcodes\\] = \\{.*?};", 40);
        headerContent = patternGotoTable.matcher(headerContent).replaceAll(String.format("_name[kNumPackedOpcodes] = {        \\\\\n%s};\n", gotoTableContent));
        try (FileWriter fileWriter = new FileWriter(source);){
            fileWriter.write(headerContent);
        }
    }

    private static void writeApkVerifierFile(String packageName, File source, ApkVerifyCodeGenerator apkVerifyCodeGenerator) throws IOException {
        if (apkVerifyCodeGenerator == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), StandardCharsets.UTF_8));
        String lines = bufferedReader.lines().collect(Collectors.joining("\n"));
        String dataPlaceHolder = "#define publicKeyPlaceHolder";
        String content = lines.replaceAll(dataPlaceHolder, dataPlaceHolder + apkVerifyCodeGenerator.generate());
        content = content.replaceAll("(#define PACKAGE_NAME) .*\n", "$1 \"" + packageName + "\"\n");
        try (FileWriter fileWriter = new FileWriter(source);){
            fileWriter.write(content);
        }
    }

    public static void writeCmakeFile(File cmakeTemp, String libName) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cmakeTemp), StandardCharsets.UTF_8));
        String lines = bufferedReader.lines().collect(Collectors.joining("\n"));
        String libNameFormat = "set\\(LIBNAME_PLACEHOLDER \"%s\"\\)";
        lines = lines.replaceAll(String.format(libNameFormat, "nmmp"), String.format(libNameFormat, libName));
        try (FileWriter fileWriter = new FileWriter(cmakeTemp);){
            fileWriter.write(lines);
        }
    }

    public static void generateCSources(File srcDir, InstructionRewriter instructionRewriter) throws IOException {
        File vmsrcFile = new File(FileUtils.getHomePath(), "tools/vmsrc.zip");
        if (!vmsrcFile.exists()) {
            vmsrcFile.getParentFile().mkdirs();
            try (InputStream inputStream = CmakeUtils.class.getResourceAsStream("/vmsrc.zip");
                 FileOutputStream outputStream = new FileOutputStream(vmsrcFile);){
                FileUtils.copyStream(inputStream, outputStream);
            }
        }
        List<File> cSources = ApkUtils.extractFiles(vmsrcFile, ".*", srcDir);
        for (File source : cSources) {
            if (source.getName().endsWith("DexOpcodes.h")) {
                CmakeUtils.writeOpcodeHeaderFile(source, instructionRewriter);
                continue;
            }
            if (source.getName().equals("CMakeLists.txt")) {
                CmakeUtils.writeCmakeFile(source, "nmmp");
                continue;
            }
            if (source.getName().endsWith("vm.h")) {
                CmakeUtils.writeRandomResolver(source);
                continue;
            }
            if (!source.getName().endsWith("JNIWrapper.h")) continue;
            CmakeUtils.writeRandomJNIWrapper(source);
        }
    }

    private static void writeRandomResolver(File source) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), StandardCharsets.UTF_8));
        String lines = bufferedReader.lines().collect(Collectors.joining("\n"));
        Pattern p11 = Pattern.compile("typedef struct \\{([^}]*?)} vmResolver;", 40);
        Matcher matcherResolver = p11.matcher(lines);
        if (matcherResolver.find()) {
            String body = matcherResolver.group(1);
            Pattern funcPattern = Pattern.compile("([^();]* \\**\\(\\*[a-zA-z0-9]*\\)\\([^();]*\\);)", 40);
            ArrayList<String> funcs = new ArrayList<String>();
            Matcher matcher = funcPattern.matcher(body);
            while (matcher.find()) {
                funcs.add(matcher.group(1));
            }
            try (FileWriter fileWriter = new FileWriter(source);){
                String doc = matcherResolver.replaceAll("typedef struct {\n" + CmakeUtils.randomList(funcs) + "} vmResolver;");
                fileWriter.write(doc);
            }
        }
    }

    private static void writeRandomJNIWrapper(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        String lines = bufferedReader.lines().collect(Collectors.joining("\n"));
        Pattern p11 = Pattern.compile("typedef struct \\{([^}]*?)} JNIWrapper;", 40);
        Matcher matcherWrapper = p11.matcher(lines);
        if (matcherWrapper.find()) {
            String body = matcherWrapper.group(1);
            Pattern funcPattern = Pattern.compile("([^();]* \\**\\(\\*[a-zA-z0-9]*\\)\\([^();]*\\);)", 40);
            ArrayList<String> funcs = new ArrayList<String>();
            Matcher matcher = funcPattern.matcher(body);
            while (matcher.find()) {
                funcs.add(matcher.group(1));
            }
            try (FileWriter fileWriter = new FileWriter(file);){
                String doc = matcherWrapper.replaceAll("typedef struct {\n" + CmakeUtils.randomList(funcs) + "} JNIWrapper;");
                fileWriter.write(doc);
            }
        }
    }

    private static String randomList(List<String> list) {
        StringBuilder sb2 = new StringBuilder();
        int size = list.size();
        for (int i11 = 0; i11 < size; ++i11) {
            Random random = new Random();
            int idx = random.nextInt(list.size());
            sb2.append(list.get(idx));
            sb2.append('\n');
            list.remove(idx);
        }
        return sb2.toString();
    }
}

