/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.CodeSource;

public class FileUtils {
    public static String getWorkPath() {
        return System.getProperty("user.dir");
    }

    public static String getHomePath() {
        CodeSource codeSource = FileUtils.class.getProtectionDomain().getCodeSource();
        try {
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            return jarFile.getParentFile().getPath();
        }
        catch (URISyntaxException e11) {
            e11.printStackTrace();
            return FileUtils.getHomePath();
        }
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static void copyStream(InputStream in2, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in2.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static void deleteFile(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                FileUtils.deleteFile(child);
            }
        }
        file.delete();
    }
}

