/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.util;

import java.io.UTFDataFormatException;

public class ModifiedUtf8 {
    public static String decode(byte[] in2, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s11 = 0;
        while (count < utfSize) {
            byte b11;
            if ((out[s11] = (char)in2[offset + count++]) < '\u0080') {
                ++s11;
                continue;
            }
            char a11 = out[s11];
            if ((a11 & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException("bad second byte at " + count);
                }
                if (((b11 = in2[offset + count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte at " + (count - 1));
                }
                out[s11++] = (char)((a11 & 0x1F) << 6 | b11 & 0x3F);
                continue;
            }
            if ((a11 & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException("bad third byte at " + (count + 1));
                }
                b11 = in2[offset + count++];
                byte c11 = in2[offset + count++];
                if ((b11 & 0xC0) != 128 || (c11 & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second or third byte at " + (count - 2));
                }
                out[s11++] = (char)((a11 & 0xF) << 12 | (b11 & 0x3F) << 6 | c11 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException("bad byte at " + (count - 1));
        }
        return new String(out, 0, s11);
    }

    public static long countBytes(String s11, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s11.length();
        for (int i11 = 0; i11 < length; ++i11) {
            char ch2 = s11.charAt(i11);
            result = ch2 != '\u0000' && ch2 <= '\u007f' ? ++result : (ch2 <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (!shortLength || result <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s11) {
        int length = s11.length();
        for (int i11 = 0; i11 < length; ++i11) {
            char ch2 = s11.charAt(i11);
            if (ch2 != '\u0000' && ch2 <= '\u007f') {
                dst[offset++] = (byte)ch2;
                continue;
            }
            if (ch2 <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch2 >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch2);
                continue;
            }
            dst[offset++] = (byte)(0xE0 | 0xF & ch2 >> 12);
            dst[offset++] = (byte)(0x80 | 0x3F & ch2 >> 6);
            dst[offset++] = (byte)(0x80 | 0x3F & ch2);
        }
    }

    public static byte[] encode(String s11) throws UTFDataFormatException {
        int utfCount = (int)ModifiedUtf8.countBytes(s11, true);
        byte[] result = new byte[utfCount];
        ModifiedUtf8.encode(result, 0, s11);
        return result;
    }

    private ModifiedUtf8() {
    }
}

