/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.protect;

import com.nmmedit.apkprotect.aab.AabFolders;
import com.nmmedit.apkprotect.aab.AabProtect;
import com.nmmedit.apkprotect.deobfus.MappingReader;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.RandomInstructionRewriter;
import com.nmmedit.apkprotect.dex2c.filters.BasicKeepConfig;
import com.nmmedit.apkprotect.dex2c.filters.ClassAndMethodFilter;
import com.nmmedit.apkprotect.dex2c.filters.ProguardMappingConfig;
import com.nmmedit.apkprotect.dex2c.filters.SimpleRules;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public class AabMain {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("No Input aab.");
            System.err.println("<inAab> [convertRuleFile]");
            return;
        }
        File aab = new File(args[0]);
        File outDir = new File(aab.getParentFile(), "bundleOut");
        ClassAndMethodFilter filterConfig = new BasicKeepConfig();
        SimpleRules simpleRules = new SimpleRules();
        if (args.length > 1) {
            simpleRules.parse(new InputStreamReader((InputStream)new FileInputStream(args[1]), StandardCharsets.UTF_8));
        } else {
            simpleRules.parse(new StringReader("class *"));
        }
        MappingReader mappingReader = new MappingReader(AabProtect.getAabProguardMapping(aab));
        filterConfig = new ProguardMappingConfig(filterConfig, mappingReader, simpleRules);
        ClassAnalyzer classAnalyzer = new ClassAnalyzer();
        AabFolders aabFolders = new AabFolders(aab, outDir);
        AabProtect aarProtect = new AabProtect.Builder(aabFolders).setInstructionRewriter(new RandomInstructionRewriter()).setFilter(filterConfig).setClassAnalyzer(classAnalyzer).build();
        aarProtect.run();
    }
}

