/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.protect;

import com.nmmedit.apkprotect.ApkFolders;
import com.nmmedit.apkprotect.ApkProtect;
import com.nmmedit.apkprotect.deobfus.MappingReader;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.RandomInstructionRewriter;
import com.nmmedit.apkprotect.dex2c.filters.BasicKeepConfig;
import com.nmmedit.apkprotect.dex2c.filters.ClassAndMethodFilter;
import com.nmmedit.apkprotect.dex2c.filters.ProguardMappingConfig;
import com.nmmedit.apkprotect.dex2c.filters.SimpleConvertConfig;
import com.nmmedit.apkprotect.dex2c.filters.SimpleRules;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public class ApkMain {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("No Input apk.");
            System.err.println("<inApk> [<convertRuleFile> mapping.txt]");
            return;
        }
        File apk = new File(args[0]);
        File outDir = new File(apk.getParentFile(), "build");
        ClassAndMethodFilter filterConfig = new BasicKeepConfig();
        SimpleRules simpleRules = new SimpleRules();
        if (args.length > 1) {
            simpleRules.parse(new InputStreamReader((InputStream)new FileInputStream(args[1]), StandardCharsets.UTF_8));
        } else {
            simpleRules.parse(new StringReader("class *"));
        }
        if (args.length > 2) {
            MappingReader mappingReader = new MappingReader(new File(args[2]));
            filterConfig = new ProguardMappingConfig(filterConfig, mappingReader, simpleRules);
        } else {
            filterConfig = new SimpleConvertConfig(new BasicKeepConfig(), simpleRules);
        }
        ClassAnalyzer classAnalyzer = new ClassAnalyzer();
        ApkFolders apkFolders = new ApkFolders(apk, outDir);
        ApkProtect apkProtect = new ApkProtect.Builder(apkFolders).setInstructionRewriter(new RandomInstructionRewriter()).setFilter(filterConfig).setClassAnalyzer(classAnalyzer).build();
        apkProtect.run();
    }
}

